<?php
	session_start();
    include ("../config.php");
    if (!isset($_SESSION['admin'])) {
        header ("Location: login.php");
	}	
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="advanced search, agency, agent, classified, directory, google maps, house, listing, property, real estate, real estate agency, real estate agent, realestate, realtor, rental">
		<meta name="description" content="Houzing - Real Estate HTML Template">
		<meta name="CreativeLayers" content="ATFN">
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/fileuploader.css">
		<link rel="stylesheet" href="css/style.css">
		<link rel="stylesheet" href="css/dashbord_navitaion.css">
		<link rel="stylesheet" href="css/upload-files.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.css">
		<!-- Title -->
		<title>Adicionar Imóvel | INVINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav -->
			<?php include 'header.php' ?>
			
			<!-- Our Dashbord -->
			<section class="our-dashbord dashbord bgc-alice-blue">
				<div class="container-fluid">
					<div class="row">
						<div class="col-xl-2 dn-lg pl0"></div>
						<div class="col-xl-10">
							<div class="row">
								<div class="col-lg-12 mb50">
									<div class="breadcrumb_content">
										<h2 class="breadcrumb_title">Adicionar Imóvel</h2>
									</div>
								</div>
							</div>
							<form class="contact_form" name="form_inserir_imovel" id="form_inserir_imovel" action="processa_inserir_imovel.php" method="post" enctype="multipart/form-data" novalidate>
								<div class="row">
									<div class="col-lg-12">
										<div class="new_property_form">
											<h4 class="title mb30">Informação Geral</h4>
											<div class="row">
												<div class="col-md-6">
													<div class="form-group mb30">
														<input name="titulo" id="titulo" class="form-control form_control" type="text" placeholder="Título do imóvel">
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group mb30">
														<div class="ui_kit_select_search add_new_property mb30">
															<select class="selectpicker" name="natureza" id="natureza" data-live-search="true" data-width="100%">
																<option value="0" disabled selected>Natureza</option>
																<?php
																	$result = $pdo->prepare("SELECT * FROM `tipo`");
																	$result->execute();
																	$num_rows = $result->rowCount();
																	if ($num_rows > 0) {
																		for($i=0; $i<$num_rows; $i++){
																			$row = $result->fetch();
																			echo '<option data-tokens="'.$row['id_tipo'].'" value="'.$row['id_tipo'].'">'.$row['tipo'].'</option>';
																		}
																	}
																?>
															</select>
														</div>
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group mb30">
														<input name="cidade" id="cidade" class="form-control form_control" type="text" placeholder="Cidade">
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group mb30">
														<input name="rua" id="rua" class="form-control form_control" type="text" placeholder="Rua">
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group mb30">
														<input name="preco" id="preco" class="form-control form_control" type="number" placeholder="Preço">
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group mb30">
														<input name="preco_promocional" id="preco_promocional" class="form-control form_control" type="number" placeholder="Preço promocional">
													</div>
												</div>
												<div class="col-sm-12">
													<div class="form-group">
														<textarea name="descricao" id="descricao" class="form-control" rows="6" placeholder="Descrição" maxlength="2400"></textarea>
													</div>
												</div>
											</div>										
										</div>
									</div>
									<div class="col-lg-12">
										<div class="new_property_form">
											<h4 class="title mb30">Detalhes</h4>
											
											<div class="row">
												<div class="col-md-4">
													<div class="form-group mb30">
														<input name="id" id="id" class="form-control form_control" type="text" placeholder="ID">
													</div>
												</div>
												<div class="col-md-4">
													<div class="ui_kit_select_search add_new_property mb30">
														<select class="selectpicker" name="estado" id="estado" data-live-search="true" data-width="100%">
															<option value="0" disabled selected>Estado</option>
															<?php
																$result = $pdo->prepare("SELECT * FROM `estado`");
																$result->execute();
																$num_rows = $result->rowCount();
																if ($num_rows > 0) {
																	for($i=0; $i<$num_rows; $i++){
																		$row = $result->fetch();
																		echo '<option data-tokens="'.$row['id_estado'].'" value="'.$row['id_estado'].'">'.$row['estado'].'</option>';
																	}
																}
															?>
														</select>
													</div>
												</div>
												<div class="col-sm-4">
													<div class="ui_kit_select_search add_new_property mb30">
														<select class="selectpicker" name="tipologia" id="tipologia" data-live-search="true" data-width="100%">
															<option value="0" disabled selected>Tipologia</option>
															<?php
																$result = $pdo->prepare("SELECT * FROM `tipologia`");
																$result->execute();
																$num_rows = $result->rowCount();
																if ($num_rows > 0) {
																	for($i=0; $i<$num_rows; $i++){
																		$row = $result->fetch();
																		echo '<option data-tokens="'.$row['id_tipologia'].'" value="'.$row['id_tipologia'].'">'.$row['tipologia'].'</option>';
																	}
																}
															?>
														</select>
													</div>
												</div>		                
												<div class="col-md-4">
													<div class="form-group mb20">
														<input name="area_bruta" id="area_bruta" class="form-control form_control" type="number" placeholder="Área bruta">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group mb20">
														<input name="area_util" id="area_util" class="form-control form_control" type="number" placeholder="Área útil">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group mb30">
														<input name="ano" id="ano" class="form-control form_control" type="number" placeholder="Ano de construção">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group mb30">
														<input name="categoria_energetica" id="categoria_energetica" class="form-control form_control" type="text" placeholder="Categoria Energética:">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group mb30">
														<input name="quartos" id="quartos" class="form-control form_control" type="number" placeholder="Quartos">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group mb30">
														<input name="wc" id="wc" class="form-control form_control" type="number" placeholder="WCs">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group mb30">
														<input name="garagem" id="garagem" class="form-control form_control" type="number" placeholder="Garagem">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group">
														<input name="latitude" id="latitude" class="form-control form_control" type="text" placeholder="Latitude (Google Maps)">
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group">
														<input name="longitude" id="longitude" class="form-control form_control" type="text" placeholder="Longitude (Google Maps)">
													</div>
												</div>												
											</div>
										</div>										
										<div class="new_property_form">
											<h4 class="title mb30">Características</h4>
											<div class="row">
												<div class="col-sm-12">
													<div class="tags_input mb20">
														<input class="form-control form_control caracteristicas" id="caracteristicas" name="caracteristicas" type="text" data-role="tagsinput" value="Ar Condicionado, Aquecimento">
													</div>
												</div>
											</div>
										</div>
										<div class="new_property_form">											
											<div class="row">
												<div class="col-sm-6">
													<h4 class="title mb30">Imagem Miniatura</h4>
													<div class="upload_file_input_add_remove">
														<span class="btn_upload">
																<input type="file" id="imag" name="img_miniatura" title="" class="input-img form-control"/>
															<span>Inserir Imagem</span>
															</span>
														<img id="ImgPreview" src="images/resource/upload-img.png" class="preview1" alt=""/>
														<button id="removeImage1" class="btn-rmv1" type="button"><span>X</span></button>
													</div>
													*A imagem deve ter a dimensão de 690 × 440 pixeis.
												</div>
												<div class="col-sm-6">
													<h4 class="title mb30">Destaque</h4>
													<input type="radio" id="null" name="destaques" value="null" checked>
													<label for="null">Sem Destaque</label><br>
													<input type="radio" id="novidade" name="destaques" value="novidade">
													<label for="novidade">Novidade</label><br>
													<input type="radio" id="destaque" name="destaques" value="destaque">
													<label for="destaque">Destaque</label><br>  
													<input type="radio" id="reservado" name="destaques" value="reservado">
													<label for="reservado">Reservado</label><br>
													<input type="radio" id="vendido" name="destaques" value="vendido">
													<label for="vendido">Vendido</label>
												</div>
											</div>
										</div>
										
										<div class="new_property_form">
											<h4 class="title mb30">Galeria de Imagens</h4>
											<div class="row">
												<div class="col-lg-12">	
													<fieldset class="form-group">
														<a href="javascript:void(0)" class="btn btn-thm" onclick="$('#pro-image').click()">Inserir Imagens</a>
														<input type="file" id="pro-image" name="pro-image[]" style="display: none;" class="form-control" multiple>
													</fieldset>
													<div class="preview-images-zone ui-sortable">
													</div>
												</div>
												*As imagens devem ter a dimensão de 1470 × 700 pixeis.
											</div>
										</div>
										<div class="new_property_form">
											<h4 class="title mb30">Imagens 3D</h4>
											<div class="row">
												<div class="col-md-12">
													<div class="form-group">
														<input name="3d" id="3d" class="form-control form_control" type="text" placeholder="Link">
													</div>
												</div>
											</div>
										</div>
											
										<div class="text-right">
											<a class="btn btn-thm listing_save_btn" onclick="checkForm()">Inserir</a>
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</section>
			<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
		</div>
		<!-- Wrapper End -->
		<script src="js/jquery-3.6.0.js"></script>
		<script src="js/jquery-migrate-3.0.0.min.js"></script>
		<script src="js/popper.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.mmenu.all.js"></script>
		<script src="js/ace-responsive-menu.js"></script>
		<script src="js/bootstrap-select.min.js"></script>
		<script src="js/snackbar.min.js"></script>
		<script src="js/simplebar.js"></script>
		<script src="js/tagsinput.js"></script>
		<script src="js/parallax.js"></script>
		<script src="js/scrollto.js"></script>
		<script src="js/jquery-scrolltofixed-min.js"></script>
		<script src="js/jquery.counterup.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/jquery.smartuploader.js"></script>
		<script src="js/progressbar.js"></script>
		<script src="js/slider.js"></script>
		<script src="js/timepicker.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/dashboard-script.js"></script>
		<!--<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM&callback=initMap"></script>
		<script src="js/googlemaps1.js"></script>-->
		<!-- Custom script for all pages --> 
		<script src="js/script.js"></script>
		<script>
			$(document).ready(function() {
				document.getElementById('pro-image').addEventListener('change', readImage, false);
				
				$( ".preview-images-zone" ).sortable();
				
				$(document).on('click', '.image-cancel', function() {
					let no = $(this).data('no');
					$(".preview-image.preview-show-"+no).remove();
				});
			});
			
			
			
			var num = 1;
			function readImage() {
				if (window.File && window.FileList && window.FileReader) {
					var files = event.target.files; //FileList object
					var output = $(".preview-images-zone");
					
					for (let i = 0; i < files.length; i++) {
						var file = files[i];
						if (!file.type.match('image')) continue;
						
						var picReader = new FileReader();
						
						picReader.addEventListener('load', function (event) {
							var picFile = event.target;
							var html =  '<div class="preview-image preview-show-' + num + '">' +
                            '<div class="image-cancel" data-no="' + num + '">x</div>' +
                            '<div class="image-zone"><img id="pro-img-' + num + '" src="' + picFile.result + '"></div>' +
                            '</div>';
							
							output.append(html);
							num = num + 1;
						});
						
						picReader.readAsDataURL(file);
					}
					//$("#pro-image").val('');
					} else {
					console.log('Browser not support');
				}
			}
			
			function validaNome(nome) {
				if (nome.length>0) {
					return true;
					} else {
					return false;
				}
			}
			
			function checkForm() {
				var msg = '';                   
				if (!validaNome(document.getElementById('titulo').value)) {
					msg += '- o titulo\n';
					$('#titulo').addClass('is-invalid');
					} else {
					$('#titulo').removeClass('is-invalid');
				}	
				if (!validaNome(document.getElementById('id').value)) {
					msg += '- o titulo\n';
					$('#id').addClass('is-invalid');
					} else {
					$('#id').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('cidade').value)) {
					msg += '- o titulo\n';
					$('#cidade').addClass('is-invalid');
					} else {
					$('#cidade').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('preco').value)) {
					msg += '- o titulo\n';
					$('#preco').addClass('is-invalid');
					} else {
					$('#preco').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('area_bruta').value)) {
					msg += '- o titulo\n';
					$('#area_bruta').addClass('is-invalid');
					} else {
					$('#area_bruta').removeClass('is-invalid');
				}
				/*
				
				if (!validaNome(document.getElementById('rua').value)) {
					msg += '- o titulo\n';
					$('#rua').addClass('is-invalid');
					} else {
					$('#rua').removeClass('is-invalid');
				}	
							
				if (!validaNome(document.getElementById('descricao').value)) {
					msg += '- o titulo\n';
					$('#descricao').addClass('is-invalid');
					} else {
					$('#descricao').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('ano').value)) {
					msg += '- o titulo\n';
					$('#ano').addClass('is-invalid');
					} else {
					$('#ano').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('latitude').value)) {
					msg += '- o titulo\n';
					$('#latitude').addClass('is-invalid');
					} else {
					$('#latitude').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('longitude').value)) {
					msg += '- o titulo\n';
					$('#longitude').addClass('is-invalid');
					} else {
					$('#longitude').removeClass('is-invalid');
				}*/
				
				if ($('#natureza').val() == null) {
					msg += '- o titulo\n';
					var $div = $('#natureza').parent("div");
					$div.addClass('is-invalid');
					} else {
					var $div = $('#natureza').parent("div");
					$div.removeClass('is-invalid');
				}				
				
				if (!msg.length > 0) {
					document.form_inserir_imovel.submit();
				}
			}
			
		</script>
	</body>
</html>