<?php
session_start();
    include ("../config.php");
    if (!isset($_SESSION['admin'])) {
        header ("Location: login.php");
	}	
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="advanced search, agency, agent, classified, directory, google maps, house, listing, property, real estate, real estate agency, real estate agent, realestate, realtor, rental">
		<meta name="description" content="Houzing - Real Estate HTML Template">
		<meta name="CreativeLayers" content="ATFN">
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<link rel="stylesheet" href="css/dashbord_navitaion.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.css">
		<!-- Title -->
		<title>Mediação | INVINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		<link rel="stylesheet" href="css/sweetalert.css">
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav -->
			<?php include 'header.php' ?>
			
			<!-- Our Dashbord -->
			<section class="our-dashbord dashbord bgc-alice-blue">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-2 dn-md pl0"></div>
						<div class="col-lg-10 col-md-12">
							<div class="sc1"></div>
							<div class="row">
								<div class="col-lg-12 mb50">
									<div class="breadcrumb_content">
										<h2 class="breadcrumb_title">Mediação</h2>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-lg-12">
								</div>
								<div class="col-lg-12">
									<div class="invoice_table property table-responsive">
										
										<table class="table table-borderless">
											<thead class="thead-light">
												<tr>
													<th scope="col">Imóveis</th>
													<th scope="col">Data de Publicação</th>
													<th scope="col">Estado</th>
													<th scope="col"></th>
													<th scope="col">Acção</th>
												</tr>
											</thead>
											<tbody>
												<?php
													$result = $pdo->prepare("SELECT * FROM `imoveis` ORDER BY `ordem` ASC");
													$result->execute();
													$num_rows = $result->rowCount();
													if ($num_rows > 0) {
														for($i=0; $i<$num_rows; $i++){
															$row = $result->fetch();
															
															
															
															if($row['preco_promocional'] != NULL || $row['preco_promocional'] != '' ){
																$preco = '	<small><del class="body-color">'.$row['preco'].'€</del></small> <br>
																<span class="heading-color fw600">'.$row['preco_promocional'].'€</span>';
																}else{
																$preco = '<span class="heading-color fw600">'.$row['preco'].'€</span>';
															}
															
															if($row['novidade'] == 1){
																$estado = 'Novidade';
																}else if($row['destaque'] == 1){
																$estado = 'Destaque';
																}else if($row['reservado'] == 1){
																$estado = 'Reservado';
																}else if($row['vendido'] == 1){
																$estado = 'Vendido';
																}else{
																$estado = '';
															}
															
															
															
															$idimovel = $row['id_imovel'];
															echo '	<tr>
															<th scope="row">
															<div class="feat_property list property">
															<div class="thumb">
															<img class="img-whp" src="../images/imoveis/'.$idimovel.'/'.$row['img_miniatura'].'" alt="">
															</div>
															<div class="thmb_cntnt">
															<ul class="tag mb0">
															<li class="list-inline-item"><a href="#">FEATURED</a></li>
															</ul>
															</div>
															<div class="details">
															<div class="tc_content">
															<h4 class="title">'.$row['imovel'].'</h4>
															<p>'.$row['rua'].', '.$row['cidade'].'</p>
															<div class="fp_meta">
															<a href="#">
															'.$preco.'
															</a>
															</div>
															</div>
															</div>
															</div>
															</th>
															<td>'.$row['data_publicacao'].'</td>
															<td class="text-thm">'.$estado.'</td>
															<td></td>
															<td class="editing_list">
															<ul>
															<li class="list-inline-item">
															<a href="editar-imovel.php?id='.$idimovel.'" data-toggle="tooltip" data-placement="top" title="Editar"><span class="flaticon-edit"></span></a>
															</li>
															<li class="list-inline-item">
															<a href="eliminar-imovel.php?id='.$idimovel.'" data-toggle="tooltip" data-placement="top" title="Eliminar"><span class="flaticon-trash"></span></a>
															</li>
															</ul>
															</td>
															</tr>';
														}
													}
												?>
												
											</tbody>
										</table>		
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
		</div>
		<!-- Wrapper End -->
		<script src="js/jquery-3.6.0.js"></script>
		<script src="js/jquery-migrate-3.0.0.min.js"></script>
		<script src="js/popper.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.mmenu.all.js"></script>
		<script src="js/ace-responsive-menu.js"></script>
		<script src="js/chart.min.js"></script>
		<script src="js/chart-custome.js"></script>
		<script src="js/bootstrap-select.min.js"></script>
		<script src="js/snackbar.min.js"></script>
		<script src="js/simplebar.js"></script>
		<script src="js/parallax.js"></script>
		<script src="js/scrollto.js"></script>
		<script src="js/jquery-scrolltofixed-min.js"></script>
		<script src="js/jquery.counterup.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/progressbar.js"></script>
		<script src="js/slider.js"></script>
		<script src="js/timepicker.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/dashboard-script.js"></script>
		<!-- Custom script for all pages --> 
		<script src="js/script.js"></script>
		<script src="js/sweetalert-dev.js"></script>
		<script>
			var value = getUrlParameter('er');
			var inserir = getUrlParameter('i');
			var editar = getUrlParameter('e');
			var eliminar = getUrlParameter('el');
			$(window).on("load", function() {
				if (inserir==1) {
					swal({ 
						title: 'Imóvel Inserido',
						text: 'O imóvel foi introduzido com sucesso.',
						type: "success" 
					},
					function() {
						window.location.href = 'mediacao.php';
					});
				} 
				
				if (editar==1) {
					swal({ 
						title: 'Imóvel Editado',
						text: 'O imóvel foi editado com sucesso.',
						type: "success" 
					},
					function() {
						window.location.href = 'mediacao.php';
					});
				} 
				
				if (eliminar==1) {
					swal({ 
						title: 'Imóvel Eliminado',
						text: 'O imóvel foi eliminado com sucesso.',
						type: "success" 
					},
					function() {
						window.location.href = 'mediacao.php';
					});
				}
				
				if (value==1) {
					swal({ 
						title: 'Erro',
						text: 'Houve um erro de leitura dos dados. Por favor tente novamente.',
						type: "error" 
					},
					function() {
						window.location.href = 'mediacao.php';
					});
				}
			}); 
			
			function getUrlParameter(sParam) {
				var sPageURL = decodeURIComponent(window.location.search.substring(1)),
				sURLVariables = sPageURL.split('&'),
				sParameterName,
				i;
				for (i=0;i<sURLVariables.length;i++) {
					sParameterName = sURLVariables[i].split('=');
					if (sParameterName[0] === sParam) {
						return sParameterName[1] === undefined ? true : sParameterName[1];
					}
				}
			};
		</script>
	</body>
</html>