<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="Mediação, Investimentos, Imóveis">
		<meta name="description" content="Contactos">
		
		<meta property="og:title" content="<?php echo $imovel; ?>" />
		<meta property="og:description" content="IN VINCI" />
		<meta property="og:url" content="http://invinci.pt/contactos.php" />
		<meta property="og:image" content="http://invinci.pt/images/RedesSociais.jpg" />
		
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.min.css">
		<!-- Title -->
		<title>Contactos | IN VINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		
		<script src="https://www.google.com/recaptcha/api.js" async defer></script>
		<style>
			.inner_page_breadcrumb{
				background-image: url(images/Banner_5.jpg);
			}
		</style>
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav --> 
			<?php include 'header.php'; ?>
			
			<!-- Inner Page Breadcrumb -->
			<section class="inner_page_breadcrumb">
			</section>
			
			<!-- Our Contact -->
			<section class="our-contact">
				<div class="container">
					<div class="row">
						<div class="col-md-5">
							<div class="form_grid">
								<h2 class="text-center mb50">Pedido de Informação</h2>
								<form class="contact_form" name="contact_form" action="processa_form.php?fr=2" method="post"  enctype="multipart/form-data" novalidate>
									<div class="row">
										<div class="col-md-12">
											<div class="form-group">
												<input name="nome"  id="nome" class="form-control" required="required" type="text" placeholder="Nome">
											</div>
										</div>
										<div class="col-md-6">
											<div class="form-group">
												<input name="telefone" id="telefone" class="form-control" required="required" type="phone" placeholder="Telefone">
											</div>
										</div>
										<div class="col-md-6">
											<div class="form-group">
												<input name="email" id="email" class="form-control required email" required="required" type="email" placeholder="Email">
											</div>
										</div>				
										<div class="col-sm-12">
											<div class="form-group">
												<textarea name="mensagem" id="mensagem" class="form-control required" rows="6" required placeholder="Menssagem"></textarea>
											</div>
										</div>
										<div class="col-sm-12">
											<div class="custom-control custom-checkbox">
												<input type="checkbox" class="custom-control-input" id="checkbox-mensagem">
												<label class="custom-control-label" for="checkbox-mensagem" id="text-checkbox">Tomo conhecimento de que a informação recolhida no formulário se destina à possibilidade de voltar a ser contactado na sequência da mensagem que envio.</label>
											</div>
										</div>
										<div class="col-sm-12">
											<div class="g-recaptcha" data-sitekey="6LcN30QhAAAAAEtaT75jRctCLmhjlRLOlt1cvHCF"></div>
											<div class="form-group mb0">
												<a type="button" class="btn btn-thm" style="padding:12px;" onclick="checkForm()">ENVIAR</a>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
						<div class="col-md-2">
						</div>
						<div class="col-md-5">
							<div class="main-title text-center">
								<h2>Como podemos ajudar?</h2>
							</div>
							<div class="row">
								<div class="col-sm-12">
									<div class="contact_icon_box mb50">
										<div class="icon float-left"><span class="flaticon-phone"></span></div>
										<div class="details">
											<a href="tel:+351916459876" style="font-size: 30px"><p>(+351) 916 459 876*</p></a>
										</div>
									</div>
								</div>
								<div class="col-sm-12">
									<div class="contact_icon_box mb50">
										<div class="icon float-left"><span class="flaticon-email"></span></div>
										<div class="details">
											<a href="mailto:geral@invinci.pt" style="font-size: 30px"><p>geral@invinci.pt</p></a>
										</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					
					</div>
			</section>
			
			<!-- Our Footer -->
			<?php include 'footer.php'; ?>
			<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
		</div>
		<!-- Wrapper End -->
		<script src="js/jquery-3.6.0.js"></script>
		<script src="js/jquery-migrate-3.0.0.min.js"></script>
		<script src="js/popper.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.mmenu.all.js"></script>
		<script src="js/ace-responsive-menu.js"></script>
		<script src="js/bootstrap-select.min.js"></script>
		<script src="js/snackbar.min.js"></script>
		<script src="js/simplebar.js"></script>
		<script src="js/parallax.js"></script>
		<script src="js/scrollto.js"></script>
		<script src="js/jquery-scrolltofixed-min.js"></script>
		<script src="js/jquery.counterup.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/progressbar.js"></script>
		<script src="js/slider.js"></script>
		<script src="js/timepicker.js"></script>
		<!--<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM&callback=initMap"></script>
		<script src="js/googlemaps1.js"></script>-->
		<!-- Custom script for all pages --> 
		<script src="js/script.js"></script>
		
		<script>
			function validaNome(nome) {
				if (nome.length>0) {
					return true;
					} else {
					return false;
				}
			}
			
			
			function checkForm() {
				var msg = '';                   
				if (!validaNome(document.getElementById('nome').value)) {
					msg += '- o titulo\n';
					$('#nome').addClass('is-invalid');
					} else {
					$('#nome').removeClass('is-invalid');
				}			
				if (!validaNome(document.getElementById('telefone').value)) {
					msg += '- o titulo\n';
					$('#telefone').addClass('is-invalid');
					} else {
					$('#telefone').removeClass('is-invalid');
				}
				if (!validaNome(document.getElementById('email').value)) {
					msg += '- o titulo\n';
					$('#email').addClass('is-invalid');
					} else {
					$('#email').removeClass('is-invalid');
				}	
				if (!validaNome(document.getElementById('mensagem').value)) {
					msg += '- o titulo\n';
					$('#mensagem').addClass('is-invalid');
					} else {
					$('#mensagem').removeClass('is-invalid');
				}			
				
				checkBox2 = document.getElementById('checkbox-mensagem');
				if(checkBox2.checked) {
					$('#text-checkbox').removeClass('is-invalid');
					$('#checkbox-mensagem').removeClass('is-invalid');
				}else{
					msg += '- o titulo\n';
					$('#text-checkbox').addClass('is-invalid');
					$('#checkbox-mensagem').addClass('is-invalid');
				}
				
				var response = grecaptcha.getResponse();
				if(response.length == 0)
				{
					msg += '- o titulo\n';
					evt.preventDefault();
					return false;
				}
				
				if (!msg.length > 0) {
					document.contact_form.submit();
				}
			}
		</script>
	</body>
</html>