<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="advanced search, agency, agent, classified, directory, google maps, house, listing, property, real estate, real estate agency, real estate agent, realestate, realtor, rental">
		<meta name="description" content="Houzing - Real Estate HTML Template">
		<meta name="CreativeLayers" content="ATFN">
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.css">
		<!-- Title -->
		<title>Sobre | INVINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<style>
			.inner_page_breadcrumb{
				background-image: url(images/Banner_5.jpg);
			}
		</style>
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav -->
			<?php include 'header.php'; ?>
			<!-- Modal -->
			<div class="sign_up_modal modal fade" id="logInModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
						</div>
						<div class="modal-body container pb30 pl0 pr0 pt0">
							<div class="row">
								<div class="col-lg-12">
									<ul class="sign_up_tab nav nav-tabs" id="myTab" role="tablist">
										<li class="nav-item">
											<a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Sign in</a>
										</li>
										<li class="nav-item">
											<a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Register</a>
										</li>
									</ul>
								</div>
							</div>
							<div class="tab-content container" id="myTabContent">
								<div class="row mt30 tab-pane fade show active pl20 pr20" id="home" role="tabpanel" aria-labelledby="home-tab">
									<div class="col-lg-12">
										<div class="login_form">
											<form action="#">
												<div class="mb-2 mr-sm-2">
													<label for="formGroupExampleInput" class="form-label mb0">Login</label>
													<input type="text" class="form-control" id="formGroupExampleInput" placeholder="Ali Tufa..">
												</div>
												<div class="form-group mb5">
													<input type="password" class="form-control" placeholder="Password">
												</div>
												<div class="custom-control custom-checkbox">
													<input type="checkbox" class="custom-control-input" id="exampleCheck2">
													<label class="custom-control-label" for="exampleCheck2">Remember me</label>
													<a class="btn-fpswd float-right text-thm" href="#">Forgot</a>
												</div>
												<button type="submit" class="btn btn-log btn-block btn-thm mt20">Sign in</button>
												<div class="row mt10">
													<div class="col-lg-12">
														<div class="user_log_info">
															<p>Username: <span>agency or agent</span></p>
															<p>Password: <span>demo</span></p>
														</div>
													</div>
												</div>
											</form>
										</div>
									</div>
								</div>
								<div class="row mt30 tab-pane fade pl20 pr20" id="profile" role="tabpanel" aria-labelledby="profile-tab">
									<div class="col-lg-12">
										<div class="sign_up_form">
											<form action="#">
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="Login">
												</div>
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="First name">
												</div>
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="Last name">
												</div>
												<div class="form-group input-group">
													<select class="selectpicker form-control" data-width="100%">
														<option data-tokens="banking">User role</option>
														<option data-tokens="digital&creative">User role 2</option>
														<option data-tokens="retail">User role 3</option>
														<option data-tokens="humanresource">User role 4</option>
													</select>
												</div>
												<div class="form-group input-group">
													<input type="email" class="form-control" placeholder="Email">
												</div>
												<div class="form-group input-group mb20">
													<input type="password" class="form-control" placeholder="Password">
												</div>
												<div class="form-group input-group mb30">
													<input type="password" class="form-control" placeholder="Re-enter password">
												</div>
												<button type="submit" class="btn btn-signup btn-block btn-dark mb0">REGISTER</button>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Inner Page Breadcrumb -->
			<section class="inner_page_breadcrumb">
			</section>
			
			<!-- Our Terms & Conditions -->
			<section class="our-terms pb70">
				<div class="container">
					<div class="terms_condition_grid">
						<div class="grids mb60 text-justify">
							<p class="mb25">A IN VINCI é uma agência de mediação e “<b>House Hunting</b>” (Caçador de Casas) profissional em Portugal, especializada na procura de imóveis. O nosso serviço é dedicado a compradores e investidores em imobiliário.</p>
							<p class="mb25">Foi fundada com o objetivo de proporcionar ao comprador um <b>único interlocutor</b> para encontrar, avaliar e negociar a sua casa ideal ao <b>melhor preço</b>, de forma independente e sem conflitos de interesses, junto do proprietário, promotor ou agência imobiliária que vende o imóvel. </p>
							<p class="mb25">A nossa missão é principalmente de procurar propriedades na região escolhida, em nome de compradores sobrecarregados, que não vivem no setor de prospeção, que têm pouco conhecimento do mercado, ou que simplesmente desejam contratar um especialista do mercado imobiliário para atender às suas necessidades específicas.</p>
							<p class="mb25">O nosso território de pesquisa é <b>todo o mercado imobiliário</b>, através das nossas parcerias com outras agências ou outros profissionais, em total transparência, mas também vendedores individuais, notários ou outros prestadores de serviços institucionais.</p>
							<p class="mb0">Ao identificar o imóvel ideal a IN VINCI luta pelo seu melhor interesse, na negociação de preço e de condições contratuais, e é recompensada com uma comissão fixa (a negociar) e paga apenas após assinatura do “Contrato Promessa Compra e Venda” (CPCV) ou Escritura, ou seja, o serviço apenas é pago se conseguirmos encontrar a sua casa de sonho.</p>
						</div>
						<div class="row mt50 mb50">
							<div class="col-md-6 col-lg-4">
								<div class="funfact_one text-center">
									<div class="details">
										<div class="timer text-thm">180</div>
										<p class="ff_title">Imóveis em comercialização</p>
									</div>
								</div>
							</div>
							<div class="col-md-6 col-lg-4">
								<div class="funfact_one text-center">
									<div class="details">
										<div class="timer text-thm">69</div>
										<p class="ff_title">Vendas Recentes</p>
									</div>
								</div>
							</div>
							<div class="col-md-6 col-lg-4">
								<div class="funfact_one text-center">
									<div class="details">
										<div class="timer text-thm">19</div>
										<p class="ff_title">Preço baixou</p>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-8">
								<div class="grids mb30">
									<h4 class="title">Vantagens do nosso serviço:</h4>
									<ul class="order_list list-style-type-bullet list-inline-item">
										<li>Conceito “Chave-na-mão” com apenas um único interlocutor</li>
										<li>Rede de parceiros (agências imobiliárias, notários, bancos, promotores, particulares)</li>
										<li>Reatividade, adaptabilidade e persuasão</li>
										<li>Poupança de tempo em pesquisas e deslocações</li>
										<li>Poder de negociação</li>
										<li>Multilingue (português, francês, inglês)</li>
										<li>Visitas eficazes</li>
										<li>Serviço 100% dedicado ao comprador</li>
									</ul>
								</div>	
								<div class="grids mb30">
									<h4 class="title">Este serviço destina-se a pessoas que:</h4>
									<ul class="order_list list-style-type-bullet list-inline-item">
										<li>Não têm tempo para fazer pesquisas de imóveis</li>
										<li>Não conhecem o mercado imobiliário local</li>
										<li>Não conseguem encontrar o imóvel que mais se adapta às suas necessidades</li>
										<li>Não têm conhecimento suficiente para negociar ao melhor preço</li>
										<li>Precisam de assistência em todo o processo de compra</li>
										<li>Gostariam de investir em imobiliário.</li>
									</ul>
								</div>
							</div>
							<div class="col-md-4 text-center">	
								<h2 class="title mb30"><b>Um contrato personalizado para clientes únicos</b></h2>
								<h2 class="title mb30" style="font-weight: 200;">Estudo do seu projeto e proposta adaptada</h2>
								<h2 class="title mb30"><b>Simplicidade</b></h2>
								<h2 class="title mb30" style="font-weight: 200;">Um contrato “chave-na-mão” feito à sua medida</h2>
								<h2 class="title mb30">Ação</h2>
								<h2 class="title mb30" style="font-weight: 200;">Assim que o contrato for assinado, a nossa missão pode começar!</h2>
								
								<h1 class="title mb30"><b>Vamos a isso!</b></h4>
							</div>
						</div>
					</div>
					
				</div>
			</section>
			
			<!-- Our Footer -->
			<?php include 'footer.php'; ?>
			<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
		</div>
		<!-- Wrapper End -->
		<script src="js/jquery-3.6.0.js"></script>
		<script src="js/jquery-migrate-3.0.0.min.js"></script>
		<script src="js/popper.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.mmenu.all.js"></script>
		<script src="js/ace-responsive-menu.js"></script>
		<script src="js/bootstrap-select.min.js"></script>
		<script src="js/snackbar.min.js"></script>
		<script src="js/simplebar.js"></script>
		<script src="js/parallax.js"></script>
		<script src="js/scrollto.js"></script>
		<script src="js/jquery-scrolltofixed-min.js"></script>
		<script src="js/jquery.counterup.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/progressbar.js"></script>
		<script src="js/slider.js"></script>
		<script src="js/timepicker.js"></script>
		<script src="js/wow.min.js"></script>
		<!-- Custom script for all pages --> 
		<script src="js/script.js"></script>
	</body>
</html>