<?php
	include 'config.php';
	
	if (!isset($_GET['id']) || $_GET['id'] == "") { 
		header ("Location: mediacao.php");
		}else{
		$id = $_GET['id'];
	}
	
	$result_imovel = $pdo->prepare("SELECT * FROM `imoveis` WHERE `id_imovel` = :id");
	$result_imovel->execute(array('id' => $id));
	$num_rows_imovel = $result_imovel->rowCount();
	
	if($num_rows_imovel>0){
		$row_imovel = $result_imovel->fetch();
		$imovel = $row_imovel['imovel'];
		$google_maps = $row_imovel['google_maps'];
		$latitude = $row_imovel['latitude'];
		$longitude = $row_imovel['longitude'];
		$idimovel = $row_imovel['id'];
		
		$foto = $row_imovel['img_miniatura'];
		
		if($row_imovel['3d'] != NULL || $row_imovel['3d'] != ''){
			$imgd = '<div class="col-lg-12">
			<div class="property_sp_videos pb40 mt50">
			<h4 class="mb30">Vista a 360°</h4>
			<div class="tab-content" id="myTabContent3">
			<iframe width="100%" height="640" style="width: 100%; height: 640px; border: none; max-width: 100%;" frameborder="0" allowfullscreen allow="xr-spatial-tracking; gyroscope; accelerometer" scrolling="no" src="'.$row_imovel['3d'].'"></iframe>
			</div>
			</div>
			</div>';
			}else{
			$imgd = '';
		}
		
		
		if($row_imovel['quartos'] != NULL || $row_imovel['quartos'] != '' ){
			$nquartos = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-bed pr5 vam"></span> '.number_format($row_imovel['quartos'], 0, ',', ' ').' Quartos</a></li>';
			}else{
			$nquartos = '';
		}
		
		if($row_imovel['wc'] != NULL || $row_imovel['wc'] != '' ){
			$nwc = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-bath pr5 vam"></span> '.number_format($row_imovel['wc'], 0, ',', ' ').' WCs</a></li>';
			}else{
			$nwc = '';
		}
		
		if($row_imovel['garagem'] != NULL || $row_imovel['garagem'] != '' ){
			$ngaragem = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-car pr5 vam"></span> '.number_format($row_imovel['garagem'], 0, ',', ' ').' Garagem</a></li>';
			}else{
			$ngaragem = '';
		}
		
		if($row_imovel['area_bruta'] != NULL || $row_imovel['area_bruta'] != '' ){
			$narea = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-ruler pr5 vam"></span> '.number_format($row_imovel['area_bruta'], 0, ',', ' ').' m<sup>2</sup></a></li>';
			}else{
			$narea = '';
		}
		
		if($row_imovel['ano'] != NULL || $row_imovel['ano'] != '' ){
			$ano = '<li class="list-inline-item mr20"><a href="#"><span class="flaticon-calendar pr5 vam"></span> Ano de construção: '.$row_imovel['ano'].'</a></li>';
			}else{
			$ano = '';
		}
		
		$result_estado = $pdo->prepare("SELECT * FROM `estado` WHERE `id_estado` = :id");
		$result_estado->execute(array('id' => $row_imovel['estado']));
		$row_estado = $result_estado->fetch();	
		$estado = $row_estado['estado'];
		
		$result_tipo = $pdo->prepare("SELECT * FROM `tipo` WHERE `id_tipo` = :id");
		$result_tipo->execute(array('id' => $row_imovel['tipo']));
		$row_tipo = $result_tipo->fetch();	
		$tipo = $row_tipo['tipo'];
		
		$result_tipologia = $pdo->prepare("SELECT * FROM `tipologia` WHERE `id_tipologia` = :id");
		$result_tipologia->execute(array('id' => $row_imovel['tipologia']));
		$row_tipologia = $result_tipologia->fetch();	
		$tipologia = $row_tipologia['tipologia'];
		

        $p = number_format($row_imovel['preco'], 0, ',', ' ');
        $pp = number_format($row_imovel['preco_promocional'], 0, ',', ' ');
            
		if($row_imovel['preco_promocional'] != NULL || $row_imovel['preco_promocional'] != '' ){
			$preco = '<div class="price mt20 mb10"><h3><small class="mr10"><del>'.$p.'€</del></small> '.$pp.'€</h3></div>';
			$preco2 = $pp;
		}else{
			$preco = '<div class="price mt20 mb10"><h3>'.$p.'€</h3></div>';
			$preco2 = $p;
		}
		}else{
		header ("Location: mediacao.php");
	}
	
	$protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://"; 
	$url = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="Mediação, Investimentos, Imóveis">
		<meta name="description" content="IN VINCI">
		
		<meta property="og:title" content="<?php echo $imovel; ?>" />
		<meta property="og:description" content="IN VINCI" />
		<meta property="og:url" content="http://invinci.pt/imovel.php?id=<?php echo $id; ?>" />
		<meta property="og:image" content="http://invinci.pt/images/imoveis/<?php echo $id; ?>/<?php echo $foto; ?>" />
		
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.min.css">
		<!-- Title -->
		<title><?php echo $imovel; ?> | IN VINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		<link rel="stylesheet" href="css/sweetalert.css">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<script src="https://www.google.com/recaptcha/api.js" async defer></script>
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav --> 
			<?php include 'header.php'; ?>
			
			<!-- Property Listing Single V4 Home Area -->
			<div class="single_page_listing_tab mt30">
				<div class="container">
					<div class="row">
						<div class="col-lg-12">
							<ul class="nav nav-tabs" id="myTab2" role="tablist">
								<li class="nav-item">
									<a class="nav-link active" id="slider-tab" data-toggle="tab" href="#slider_tabs" role="tab" aria-controls="slider_tabs" aria-selected="true"><span class="flaticon-picture color-white"></span></a>
								</li>
								<?php
									if($latitude != NULL && $longitude != NULL){
										echo '<li class="nav-item">
										<a class="nav-link" id="map-tab" data-toggle="tab" href="#map_tabs" role="tab" aria-controls="map_tabs" aria-selected="false"><span class="flaticon-map color-white"></span></a>
										</li>';
									}
								?>								
							</ul>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="tab-content" id="myTabContent2">
								<div class="tab-pane fade show active" id="slider_tabs" role="tabpanel" aria-labelledby="slider-tab">
									<!-- 10th Home Slider -->
									<div class="home10-mainslider">
										<div class="container p0">
											<div class="row">
												<div class="col-lg-12">
													<div class="property_sp3_slider psp_v5">
														<?php
															$result_fotos = $pdo->prepare("SELECT * FROM `imoveis-imagens` WHERE `id_imovel` = :id");
															$result_fotos->execute(array('id' => $id));
															$num_rows_fotos = $result_fotos->rowCount();
															
															if ($num_rows_fotos > 0) {
																for($i=0; $i<$num_rows_fotos; $i++){
																	$row_fotos = $result_fotos->fetch();
																	
																	$imgx = $row_fotos['imagem'];
																	/*
																	    	echo '	<div class="item">
                    																	<div class="sps_content">
                    																	<div class="thumb">
                    																	<div class="single_product">
                    																	<div class="single_item">
                    																	<div class="thumb">
                    																	<!--<img class="img-fluid bdrs3" src="images/imoveis/'.$id.'/'.$imgx.'" alt="">-->
                    																    <img data-src="images/imoveis/'.$id.'/'.$imgx.'" class="img-fluid bdrs3 lazyload" alt="">
                    																	</div>
                    																	</div>
                    																	<!--<a class="product_popup popup-img" href="images/imoveis/'.$id.'/'.$imgx.'"><span class="flaticon-zoom-in"></span></a>-->
                    																	</div>
                    																	</div>
                    																	</div>
                    																	</div>';
																	*/
																	echo '	<div class="item">
																	<div class="sps_content">
																	<div class="thumb">
																	<div class="single_product">
																	<div class="single_item">
																	<div class="thumb">
																    <img data-src="images/imoveis/'.$id.'/'.$imgx.'" class="img-fluid bdrs3 lazyload" alt="'.$imgx.'">
																	</div>
																	</div>
																	</div>
																	</div>
																	</div>
																	</div>';
																}
															}
														?>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php
									if($latitude != NULL && $longitude != NULL){
										echo '<div class="tab-pane fade" id="map_tabs" role="tabpanel" aria-labelledby="map-tab">
										<div class="h600" id="map-canvas"></div>
										</div>
										<div class="tab-pane fade" id="street_view" role="tabpanel" aria-labelledby="street-view-tab">
										<iframe class="h600 w100" src="" allowfullscreen></iframe>
										</div>';
									}
								?>
								
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Agent Single Grid View -->
			<section class="our-agent-single pt0 pb0">
				<div class="container">
					<div class="row mt30 mb30">
						<div class="col-xl-8 col-lg-8 col-md-12">
							<div class="single_property_title mt30-767">
								<div class="media">
									<div class="media-body">
										<h2 class="mt-0"><?php echo $imovel; ?></h2>
										<div class="df db-400 mb20-400">
											<p class="mr10"><?php echo $row_imovel['rua'];?>, <?php echo $row_imovel['cidade'];?></p>                  
										</div>
										<ul class="prop_details mb0">
											<?php
												echo $nquartos.$nwc.$ngaragem.$narea.$ano;
											?>
										</ul>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xl-4 col-lg-4 col-sm-10 col-10">
							<div class="single_property_social_share_content text-right tal-md">								
								<?php echo $preco; ?>
								
								<div class="row mobile-social-share d-none d-lg-block">
									<div id="socialHolder" class="col-md-12">
										<div id="socialShare" class="btn-group share-group">											
											<a data-toggle="dropdown" class="btn btn-info">
												<i class="fa fa-share-alt fa-inverse"></i>
											</a>
											<ul class="dropdown-menu">
												<li>
													<a data-original-title="Facebook" rel="tooltip" target="_blank" href="https://www.facebook.com/sharer.php?u=<?php echo $url; ?>" class="btn btn-facebook" data-placement="left">
														<i class="fa fa-facebook"></i>
													</a>
												</li>	
												<li>
													<a data-original-title="LinkedIn" rel="tooltip" target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo $url; ?>" class="btn btn-linkedin" data-placement="left">
														<i class="fa fa-linkedin"></i>
													</a>
												</li>
											</ul>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-sm-2 col-2">
							<div class="single_property_social_share_content text-right tal-md">	
								<div class="row mobile-social-share d-block d-lg-none">
									<div id="socialHolder" class="col-md-12">
										<div id="socialShare" class="btn-group share-group" style="margin-top: 15px">											
											<a data-toggle="dropdown" class="btn btn-info">
												<i class="fa fa-share-alt fa-inverse"></i>
											</a>
											<ul class="dropdown-menu">
												<li>
													<a data-original-title="Facebook" rel="tooltip" target="_blank" href="https://www.facebook.com/sharer.php?u=<?php echo $url; ?>" class="btn btn-facebook" data-placement="left">
														<i class="fa fa-facebook"></i>
													</a>
												</li>	
												<li>
													<a data-original-title="LinkedIn" rel="tooltip" target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo $url; ?>" class="btn btn-linkedin" data-placement="left">
														<i class="fa fa-linkedin"></i>
													</a>
												</li>
											</ul>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="container">
				<div class="row">
					<div class="col-lg-8 col-xl-9">
						<!--<div class="row">-->
						<div class="col-lg-12">
							<div class="listing_single_description mt50 mb60">
								<h4 class="mb30">Descrição</h4>
								<p class="first-Description mb25"><?php echo nl2br($row_imovel['descricao']);?></p>
							</div>
						</div>
						<!--</div>-->
						<div class="col-lg-12">
						<div class="additional_details pb40 mt50 bb1">
							<div class="row">
								<div class="col-lg-12">
									<h4 class="mb15">Detalhes</h4>
								</div>
								<div class="col-md-6 col-lg-6 col-xl-4">
									<ul class="list-inline-item">
										<li><p>ID:</p></li>
										<li><p>Preço:</p></li>
										<li><p>Estado:</p></li>
										<li><p>Natureza:</p></li>																						
									</ul>
									<ul class="list-inline-item">
										<li><p><span><?php if($idimovel != '' || $idimovel != NULL){ echo $idimovel;}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($preco2 != '' || $preco2 != NULL){ echo $preco2."€";}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($estado != '' || $estado != NULL){ echo $estado;}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($tipo != '' || $tipo != NULL){ echo $tipo;}else{ echo '-';}?></span></p></li>												
									</ul>
								</div>
								<div class="col-md-6 col-lg-6 col-xl-4">
									<ul class="list-inline-item">
										<li><p>Tipologia:</p></li>		
										<li><p>Área Bruta:</p></li>
										<li><p>Área Útil:</p></li>
										<li><p>Ano de construção:</p></li>											
										
									</ul>
									<ul class="list-inline-item">
										<li><p><span><?php if($tipologia != '' || $tipologia != NULL){ echo $tipologia;}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($row_imovel['area_bruta'] != '' || $row_imovel['area_bruta'] != NULL){ echo number_format($row_imovel['area_bruta'], 0, ',', ' ')." m<sup>2</sup>";}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($row_imovel['area_util'] != '' || $row_imovel['area_util'] != NULL){ echo number_format($row_imovel['area_util'], 0, ',', ' ')." m<sup>2</sup>";}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($row_imovel['ano'] != '' || $row_imovel['ano'] != NULL){ echo $row_imovel['ano'];}else{ echo '-';} ?></span></p></li>
										
									</ul>
								</div>
								<div class="col-md-6 col-lg-6 col-xl-4">
									<ul class="list-inline-item">
										<li><p>Categoria Energética:</p></li>	
										<li><p>Quartos:</p></li>
										<li><p>WCs:</p></li>
										<li><p>Garagem:</p></li>
									</ul>
									<ul class="list-inline-item">
										<li><p><span><?php if($row_imovel['certificado_energetico'] != '' || $row_imovel['certificado_energetico'] != NULL){ echo $row_imovel['certificado_energetico'];}else{ echo '-';} ?></span></p></li>		
										<li><p><span><?php if($row_imovel['quartos'] != '' || $row_imovel['quartos'] != NULL){ echo $row_imovel['quartos'];}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($row_imovel['wc'] != '' || $row_imovel['wc'] != NULL){ echo  $row_imovel['wc'];}else{ echo '-';} ?></span></p></li>
										<li><p><span><?php if($row_imovel['garagem'] != '' || $row_imovel['garagem'] != NULL){ echo $row_imovel['garagem'];}else{ echo '-';} ?></span></p></li>
									</ul>
								</div>
								</div>
							</div>
						</div>
						<?php
							$result_caracteristicas = $pdo->prepare("SELECT * FROM `imoveis-caracteristicas` WHERE `id_imovel` = :id");
							$result_caracteristicas->execute(array('id' => $id));
							$num_rows_caracteristicas = $result_caracteristicas->rowCount();
							
							if ($num_rows_caracteristicas > 0) {
								echo '<div class="col-lg-12">
								<div class="additional_details pb40 mt50 bb1">
								<div class="row">
								<div class="col-lg-12">
								<h4 class="mb30">Características</h4>
								</div>';
								for($i=0; $i<$num_rows_caracteristicas; $i++){
									$row_caracteristicas = $result_caracteristicas->fetch();
									
									echo '	<div class="col-sm-6 col-xl-3">
									<div class="listing_feature_iconbox mb30">
									<div class="icon float-left mr10"><span class="flaticon-point"></span></div>
									<div class="details">
									<div class="title">'.$row_caracteristicas['caracteristica'].'</div>
									</div>
									</div>
									</div>';
								}
								echo '         </div>
								</div>
								</div>';
							}
							?>
							
							<?php echo $imgd; ?>
						</div>
						
						<div class="col-lg-4 col-xl-3">
							<div class="listing_single_sidebar">
								<div class="sidebar_agent_search_widget mb30">
									<div class="media">
										<h3>Pedido de Informação</h3>
									</div>
									<div class="agent_search_form">
										<form class="contact_form" name="form_contacto" id="form_contacto" action="processa_form.php?fr=1" method="post" enctype="multipart/form-data" novalidate>
											<div class="form-group input-group mb30">
												<input type="hidden" class="form-control form_control" id="imovel" name="imovel" value="<?php echo $imovel; ?>">
												<input type="hidden" class="form-control form_control" id="id" name="id" value="<?php echo $_GET['id']; ?>">
												<input type="text" class="form-control form_control" id="nome" name="nome" placeholder="Nome">
											</div>
											<div class="form-group input-group mb30">
												<input type="text" class="form-control form_control" id="telefone" name="telefone" placeholder="Telefone">
											</div>
											<div class="form-group input-group mb30">
												<input type="email" class="form-control form_control" id="email" name="email" placeholder="E-mail">
											</div>
											<div class="form-group input-group mb30">
												<textarea class="form-control" rows="5" id="mensagem" name="mensagem" placeholder="Mensagem"></textarea>
											</div>
											
											<div class="ui_kit_checkbox">
												<div class="custom-control custom-checkbox">
													<input type="checkbox" class="custom-control-input" id="customCheck1">													
													<label class="custom-control-label" id="labelcustomCheck1" for="customCheck1">Tomo conhecimento de que a informação recolhida no formulário se destina à possibilidade de voltar a ser contactado na sequência da mensagem que envio.</label>
												</div>
												<div class="g-recaptcha" data-sitekey="6LcN30QhAAAAAEtaT75jRctCLmhjlRLOlt1cvHCF"></div>
											</div>
											<a class="btn btn-block btn-thm mb10" style="padding:17px;" onclick="checkForm()">ENVIAR</a>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	
	
	<!-- Our Footer -->
	<?php include 'footer.php'; ?>
	<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
</div>
<!-- Wrapper End -->
<script src="js/jquery-3.6.0.js"></script>
<script src="js/jquery-migrate-3.0.0.min.js"></script>
<script src="js/popper.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.mmenu.all.js"></script>
<script src="js/ace-responsive-menu.js"></script>
<script src="js/bootstrap-select.min.js"></script>
<script src="js/chart.min.js"></script>
<!--<script src="js/chart-custome.js"></script>-->
<script src="js/isotop.js"></script>
<script src="js/snackbar.min.js"></script>
<script src="js/simplebar.js"></script>
<script src="js/parallax.js"></script>
<script src="js/scrollto.js"></script>
<script src="js/jquery-scrolltofixed-min.js"></script>
<script src="js/jquery.counterup.js"></script>
<script src="js/progressbar.js"></script>
<script src="js/slider.js"></script>
<script src="js/timepicker.js"></script>
<script src="js/wow.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCvBHns_M55N0CqkG2C0SPgHZ4nNZHU_oY"></script>

<!-- Custom script for all pages --> 
<script src="js/script.js"></script>
<script src="js/sweetalert-dev.js"></script>

<script src="js/lazysizes.min.js" async></script>
<script>
	var MY_MAPTYPE_ID = 'style_KINESB';
	
	function initialize() {
		var featureOpts = [
		{
			"featureType": "administrative",
			"elementType": "labels.text.fill",
			"stylers": [
			{
				"color": "#666666"
			}
			]
		},
		{
			"featureType": 'all',
			"elementType": 'labels',
			"stylers": [
			{ visibility: 'simplified' }
			]
		},
		{
			"featureType": "landscape",
			"elementType": "all",
			"stylers": [
			{
				"color": "#e2e2e2"
			}
			]
		},
		{
			"featureType": "poi",
			"elementType": "all",
			"stylers": [
			{
				"visibility": "off"
			}
			]
		},
		{
			"featureType": "road",
			"elementType": "all",
			"stylers": [
			{
				"saturation": -100
			},
			{
				"lightness": 45
			},
			{
				"visibility": "off"
			}
			]
		},
		{
			"featureType": "road.highway",
			"elementType": "all",
			"stylers": [
			{
				"visibility": "off"
			}
			]
		},
		{
			"featureType": "road.arterial",
			"elementType": "labels.icon",
			"stylers": [
			{
				"visibility": "off"
			}
			]
		},
		{
			"featureType": "transit",
			"elementType": "all",
			"stylers": [
			{
				"visibility": "off"
			}
			]
		},
		{
			"featureType": "water",
			"elementType": "all",
			"stylers": [
			{
				"color": "#aadaff"
			},
			{
				"visibility": "on"
			}
			]
		}
		];
		
		
		var latitude = <?php echo $latitude; ?>;
		var longitude = <?php echo $longitude; ?>;
		
		var myGent = new google.maps.LatLng(latitude, longitude);	
		var Kine = new google.maps.LatLng(latitude, longitude);	
		var mapOptions = {
			zoom: 15,
			mapTypeControl: true,
			zoomControl: true,
			zoomControlOptions: {
				style: google.maps.ZoomControlStyle.SMALL,
				position: google.maps.ControlPosition.LEFT_TOP
			},
			mapTypeId: google.maps.MapTypeId.ROADMAP,
			scaleControl: true,
			streetViewControl: false,
			center: myGent
		}
		var map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);  
		var styledMapOptions = {
			name: 'style_KINESB'
		};
		
		var image = 'images/pointmap.png';
		var marker = new google.maps.Marker({
			position: Kine,
			map: map,
			animation: google.maps.Animation.DROP,
			icon: image
		});
		
		var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
		map.mapTypes.set(MY_MAPTYPE_ID, customMapType);
		
	}
	google.maps.event.addDomListener(window, 'load', initialize);
	
	
	
	function validaNome(nome) {
		if (nome.length>0) {
			return true;
			} else {
			return false;
		}
	}
	
	function checkForm() {
		var msg = '';                   
		if (!validaNome(document.getElementById('nome').value)) {
			msg += '- o titulo\n';
			$('#nome').addClass('is-invalid');
			} else {
			$('#nome').removeClass('is-invalid');
		}			
		if (!validaNome(document.getElementById('telefone').value)) {
			msg += '- o titulo\n';
			$('#telefone').addClass('is-invalid');
			} else {
			$('#telefone').removeClass('is-invalid');
		}
		if (!validaNome(document.getElementById('email').value)) {
			msg += '- o titulo\n';
			$('#email').addClass('is-invalid');
			} else {
			$('#email').removeClass('is-invalid');
		}	
		if (!validaNome(document.getElementById('mensagem').value)) {
			msg += '- o titulo\n';
			$('#mensagem').addClass('is-invalid');
			} else {
			$('#mensagem').removeClass('is-invalid');
		}			
		
		checkBox = document.getElementById('customCheck1');
		if(checkBox.checked) {
			$('#customCheck1').removeClass('is-invalid');
			}else{
			msg += '- o titulo\n';
			$('#customCheck1').addClass('is-invalid');
		}
		/*
		checkBox2 = document.getElementById('ccheckbox-mensagem');
		if(checkBox2.checked) {
			$('#text-checkbox').removeClass('is-invalid');
		}else{
			msg += '- o titulo\n';
			$('#text-checkbox').addClass('is-invalid');
		}*/
				
		var response = grecaptcha.getResponse();
		if(response.length == 0)
		{
			msg += '- o titulo\n';
		//	evt.preventDefault();
			return false;
		}
		
		if (!msg.length > 0) {
			document.form_contacto.submit();
		}
	}
	
	
	
	var value = getUrlParameter('er');
	var formulario = getUrlParameter('f');
	var id = getUrlParameter('id');
	$(window).on("load", function() {
		if (formulario==1) {
			swal({ 
				title: 'Pedido Enviado',
				text: 'O pedido de informação foi enviado com sucesso.',
				type: "success" 
			},
			function() {
				window.location.href = 'imovel.php?id='+id;
			});
		} 
		
		if (value==1) {
			swal({ 
				title: 'Erro',
				text: 'Houve um erro de leitura dos dados. Por favor tente novamente.',
				type: "error" 
			},
			function() {
				window.location.href = 'imovel.php?id='+id;
			});
		}
	}); 
	
	function getUrlParameter(sParam) {
		var sPageURL = decodeURIComponent(window.location.search.substring(1)),
		sURLVariables = sPageURL.split('&'),
		sParameterName,
		i;
		for (i=0;i<sURLVariables.length;i++) {
			sParameterName = sURLVariables[i].split('=');
			if (sParameterName[0] === sParam) {
				return sParameterName[1] === undefined ? true : sParameterName[1];
			}
		}
	};
</script>
</body>
</html>										