<?php
	include 'config.php';
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="Mediação, Investimentos, Imóveis">
		<meta name="description" content="Mediação">
		
		<meta property="og:title" content="Mediação" />
		<meta property="og:description" content="IN VINCI" />
		<meta property="og:url" content="https://invinci.pt/index.php" />
		<meta property="og:image" content="https://invinci.pt/images/RedesSociais.jpg" />
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.min.css">
		<!-- Title -->
		<title>Mediação | IN VINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<style>
			.inner_page_breadcrumb{
				background-image: url(images/Banner_5.jpg);
			}
		</style>
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav --> 
			<?php include 'header.php'; ?>
			<!-- Modal -->
			<div class="sign_up_modal modal fade" id="logInModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
						</div>
						<div class="modal-body container pb30 pl0 pr0 pt0">
							<div class="row">
								<div class="col-lg-12">
									<ul class="sign_up_tab nav nav-tabs" id="myTab" role="tablist">
										<li class="nav-item">
											<a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Sign in</a>
										</li>
										<li class="nav-item">
											<a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Register</a>
										</li>
									</ul>
								</div>
							</div>
							<div class="tab-content container" id="myTabContent">
								<div class="row mt30 tab-pane fade show active pl20 pr20" id="home" role="tabpanel" aria-labelledby="home-tab">
									<div class="col-lg-12">
										<div class="login_form">
											<form action="#">
												<div class="mb-2 mr-sm-2">
													<label for="formGroupExampleInput" class="form-label mb0">Login</label>
													<input type="text" class="form-control" id="formGroupExampleInput" placeholder="Ali Tufa..">
												</div>
												<div class="form-group mb5">
													<input type="password" class="form-control" placeholder="Password">
												</div>
												<div class="custom-control custom-checkbox">
													<input type="checkbox" class="custom-control-input" id="exampleCheck2">
													<label class="custom-control-label" for="exampleCheck2">Remember me</label>
													<a class="btn-fpswd float-right text-thm" href="#">Forgot</a>
												</div>
												<button type="submit" class="btn btn-log btn-block btn-thm mt20">Sign in</button>
												<div class="row mt10">
													<div class="col-lg-12">
														<div class="user_log_info">
															<p>Username: <span>agency or agent</span></p>
															<p>Password: <span>demo</span></p>
														</div>
													</div>
												</div>
											</form>
										</div>
									</div>
								</div>
								<div class="row mt30 tab-pane fade pl20 pr20" id="profile" role="tabpanel" aria-labelledby="profile-tab">
									<div class="col-lg-12">
										<div class="sign_up_form">
											<form action="#">
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="Login">
												</div>
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="First name">
												</div>
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="Last name">
												</div>
												<div class="form-group input-group">
													<select class="selectpicker form-control" data-width="100%">
														<option data-tokens="banking">User role</option>
														<option data-tokens="digital&creative">User role 2</option>
														<option data-tokens="retail">User role 3</option>
														<option data-tokens="humanresource">User role 4</option>
													</select>
												</div>
												<div class="form-group input-group">
													<input type="email" class="form-control" placeholder="Email">
												</div>
												<div class="form-group input-group mb20">
													<input type="password" class="form-control" placeholder="Password">
												</div>
												<div class="form-group input-group mb30">
													<input type="password" class="form-control" placeholder="Re-enter password">
												</div>
												<button type="submit" class="btn btn-signup btn-block btn-dark mb0">REGISTER</button>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Search Field Modal -->
			<section class="modal fade search_dropdown" id="staticBackdrop" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered modal-lg">
					<div class="modal-content">
						<div class="modal-header">
							<h6 class="modal-title">PESQUISA AVANÇADA</h6>
							<a class="closer" data-dismiss="modal" aria-label="Close" href="#"><span aria-hidden="true"><img src="images/icons/close.svg" alt="close.svg"></span></a>
						</div>
						<div class="modal-body">
							<div class="popup_modal_wrapper">
								<div class="container">
									<div class="row">
										<div class="col-lg-6">
											<div class="adv_src_pmodal">
												<h6 class="title">Quartos</h6>
												<div class="ui_kit_select_box">
													<select class="selectpicker custom-select-lg mb20">
														<option value="">Escolha uma opção</option>
														<option value="1">T0</option>
														<option value="2">T1</option>
														<option value="3">T2</option>
														<option value="4">T3</option>
														<option value="5">T4</option>
														<option value="5">T4+</option>
													</select>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="adv_src_pmodal">
												<h6 class="title">Casas de Banho</h6>
												<div class="ui_kit_select_box">
													<select class="selectpicker custom-select-lg mb20">
														<option value="">Escolha uma opção</option>
														<option value="1">1</option>
														<option value="2">2</option>
														<option value="3">3</option>
														<option value="4">4</option>
														<option value="5">5</option>
													</select>
												</div>
											</div>
										</div>
										<div class="col-lg-6 mb30-md">
											<div class="adv_src_pmodal">
												<h6 class="title">Área</h6>
												<div class="form-group">
													<input type="text" class="form-control area_input float-left" placeholder="Mín. m²">
												</div>
												<div class="form-group">
													<input type="text" class="form-control area_input float-right" placeholder="Max. m²">
												</div>
											</div>
										</div>										
										<div class="col-lg-6">
											<div class="adv_src_pmodal">
												<h6 class="title">Preço</h6>
												<div class="mt20" id="slider"></div>
												<span id="slider-range-value1"></span>
												<span id="slider-range-value2"></span>
											</div>
										</div>
										<div class="col-lg-6 mb30-md">
											<div class="adv_src_pmodal">
												<h6 class="title">ESTADO</h6>
												<div class="ui_kit_select_box">
													<select class="selectpicker custom-select-lg mb20">
														<option value="">Escolha uma opção</option>
														<option value="1">Em construção</option>
														<option value="2">Novo</option>
														<option value="3">Restaurado</option>
														<option value="4">Usado</option>
													</select>
												</div>
											</div>
										</div>
									</div>
									<div class="row mt30">
										<div class="col-lg-12">
											<div class="adv_src_pmodal">
												<h6><span class="title">Características</span></h6>
											</div>
										</div>
										<div class="col-sm-6 col-lg-4">
											<div class="adv_src_pmodal mb20">
												<div class="ui_kit_checkbox">
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM1">
														<label class="custom-control-label" for="customCheckM1">Ar Condicionado</label>
													</div>
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM2">
														<label class="custom-control-label" for="customCheckM2">Arrecadação</label>
													</div>
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM3">
														<label class="custom-control-label" for="customCheckM3">Piscina</label>
													</div>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-lg-4">
											<div class="adv_src_pmodal mb20">
												<div class="ui_kit_checkbox">
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM4">
														<label class="custom-control-label" for="customCheckM4">Cozinha Equipada</label>
													</div>
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM5">
														<label class="custom-control-label" for="customCheckM5">Energias Renováveis</label>
													</div>													
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM6">
														<label class="custom-control-label" for="customCheckM6">Jardim</label>
													</div>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-lg-4">
											<div class="adv_src_pmodal mb20">
												<div class="ui_kit_checkbox">
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM7">
														<label class="custom-control-label" for="customCheckM7">Quintal</label>
													</div>
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM8">
														<label class="custom-control-label" for="customCheckM8">Terraço</label>
													</div>
													<div class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" id="customCheckM9">
														<label class="custom-control-label" for="customCheckM9">Varanda</label>
													</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="adv_src_pmodal">
												<button class="btn btn-block btn-thm"><span class="fa fa-search mr15"></span>PESQUISAR</button>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			
			<!-- 6th Home Design -->
			<!--<section class="listing-home-bg parallax pt30-520" data-stellar-background-ratio="0.2">
				<div class="container">
					<div class="row posr">
						<div class="col-lg-12 pl0-lg pl15-md">
							<div class="paralax_home_search_content custom_width">
								<div class="home_tabs">
									<ul class="nav justify-content-center nav-tabs" id="myTab2" role="tablist">
										<li class="nav-item" role="presentation">
											<a class="nav-link active" id="buy-tab" data-toggle="tab" href="#buy" role="tab" aria-controls="buy" aria-selected="true"></a>
										</li>
									</ul>
									<div class="tab-content" id="myTabContent2">
										<div class="tab-pane fade show active" id="buy" role="tabpanel" aria-labelledby="buy-tab">
											<div class="home_adv_srch_opt">
												<div class="wrapper">
													<div class="home_adv_srch_form">
														<form class="bgc-white p20">
															<div class="form-row align-items-center">
																<div class="col-auto home_form_input mb15-md">
																	<div class="form-group style2 mb-2 pl10 pl0-lg">
																		<label>TIPO DE IMÓVEL</label>
																		<div class="select-wrap style2-dropdown">
																			<select class="selectpicker show-tick" multiple>
																				<option value="1">Apartamentos</option>
																				<option value="2">Armazéns</option>
																				<option value="3">Escritórios</option>
																				<option value="4">Garagens</option>
																				<option value="6">Lojas</option>
																				<option value="7">Moradias</option>
																				<option value="8">Prédios</option>
																				<option value="9">Quintas e Herdades</option>
																				<option value="10">Terrenos</option>
																			</select>
																		</div>
																	</div>
																</div>
																<div class="col-auto home_form_input mb15-md">
																	<div class="form-group style1 mb-2 ml10 ml0-767">
																		<label>DISTRITO</label>
																			<div class="select-wrap style2-dropdown">
																			<select class="selectpicker">
																				<option value="1">Aveiro</option>
																				<option value="2">Beja</option>
																				<option value="3">Braga</option>
																				<option value="4">Bragança</option>
																				<option value="5">Castelo Branco</option>
																				<option value="6">Coimbra</option>
																				<option value="7">Évora</option>
																				<option value="8">Faro</option>
																				<option value="9">Guarda</option>
																				<option value="10">Leiria</option>
																				<option value="11">Portalegre</option>
																				<option value="12">Porto</option>
																				<option value="13">Santarém</option>
																				<option value="14">Setúbal</option>
																				<option value="15">Viana Do Castelo</option>
																				<option value="16">Vila Real</option>
																				<option value="17">Viseu</option>																				
																			</select>
																		</div>
																	</div>
																</div>
																<div class="col-auto home_form_input mb15-md">
																	<div class="form-group style2 mb-2 pl10 pl0-lg">
																		<label>CONCELHO</label>																		
																		<div class="select-wrap style2-dropdown">
																			<select class="selectpicker" multiple>
																				<option value="0">Todos</option>
																				<option value="1">Agueda</option>
																				<option value="2">Albergaria-A-Velha</option>
																				<option value="3">Anadia</option>
																				<option value="4">Arouca</option>
																				<option value="5">Aveiro</option>
																				<option value="6">Castelo De Paiva</option>
																				<option value="7">Espinho</option>
																				<option value="8">Estarreja</option>
																				<option value="9">Ilhavo</option>
																				<option value="10">Mealhada</option>
																				<option value="11">Murtosa</option>
																				<option value="12">Oliveira De Azemeis</option>
																				<option value="13">Oliveira Do Bairro</option>
																				<option value="14">Ovar</option>
																				<option value="15">Santa Maria Da Feira</option>
																				<option value="1">Sao Joao Da Madeira</option>
																				<option value="1">Sever Do Vouga</option>
																				<option value="1">Vagos</option>
																				<option value="1">Vale De Cambra</option>																		
																			</select>
																		</div>
																	</div>
																</div>																
																<div class="col-auto home_form_adv_srch_form_btn mb20-md">
																	<div class="adv_srch_btn dropbtn ml0-767" data-toggle="modal" data-target="#staticBackdrop">
																		<i class="flaticon-setting-lines mr10 mt10 mt0-md flr-520"></i>
																		Pesquisa <br class="dn-767"> avançada
																	</div>
																</div>
																<div class="col-auto home_form_input2">
																	<button type="submit" class="btn search-btn ml0-767"><span class="fa fa-search"></span> PESQUISAR</button>
																</div>
															</div>
														</form>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			-->
			
			<!-- Inner Page Breadcrumb -->
			
			<section class="inner_page_breadcrumb">
				<!--<div class="container">
					<div class="row justify-content-center">
						<div class="col-xl-6">
							<div class="breadcrumb_content">
								<h1 class="breadcrumb_title" style="margin-bottom: 0 !important;  color: #1C2945">SELEÇÃO INVINCI</h1>
							</div>
						</div>
					</div>
				</div>-->
			</section>
			
			
			<!-- Listing Grid View -->
			<section class="our-listing pb30-991">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<h2 class="text-center mb50">SELEÇÃO IN VINCI</h2>						
						</div>
						<div class="col-xl-12">
							<div class="row">
								<div class="listing_filter_row dif db-767">
									<div class="col-sm-12 col-md-4 col-lg-4 col-xl-5">
										<div class="left_area tac-xsd mb30-767">
											<?php
												$result_imoveis = $pdo->prepare("SELECT * FROM `imoveis`");
												$result_imoveis->execute();
												$num_rows_imoveis = $result_imoveis->rowCount();
											?>
											<p class="mb0 mt10"><span class="heading-color"><?php echo $num_rows_imoveis;?></span> Imóveis</p>
										</div>
									</div>
									<!--
									<div class="col-sm-12 col-md-8 col-lg-8 col-xl-7">
										<div class="listing_list_style tac-767">
											<ul class="mb0">
												<li class="list-inline-item dropdown text-left bb2"><span class="stts">Ordenar por:</span>
													<select class="selectpicker">
														<option>Mais Recentes</option>
														<option>Mais Antigos</option>
														<option>Maior Preço</option>
														<option>Menos Preço</option>
													</select>
												</li>
											</ul>
										</div>
									</div>
									-->
								</div>
							</div>
							<div class="row">
								<?php
									include 'config.php';

									$result = $pdo->prepare("SELECT * FROM `imoveis` ORDER BY `ordem` ASC");
									$result->execute();
									$num_rows = $result->rowCount();
									if ($num_rows > 0) {
										for($i=0; $i<$num_rows; $i++){
											$row = $result->fetch();
											
											if($row['quartos'] != NULL || $row['quartos'] != '' ){
												$nquartos = '<li class="list-inline-item"><a href=""><span class="flaticon-bed"></span> <br>'.$row['quartos'].'</a></li>';
											}else{
												$nquartos = '';
											}
											
											if($row['wc'] != NULL || $row['wc'] != '' ){
												$nwc = '<li class="list-inline-item"><a href=""><span class="flaticon-bath"></span> <br>'.$row['wc'].'</a></li>';
											}else{
												$nwc = '';
											}
											
											if($row['garagem'] != NULL || $row['garagem'] != '' ){
												$ngaragem = '<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>'.$row['garagem'].'</a></li>';
											}else{
												$ngaragem = '';
											}
											
											if($row['area_bruta'] != NULL || $row['area_bruta'] != '' ){
												$narea = '<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>'.number_format($row['area_bruta'], 0, ',', ' ').'</a></li>';
											}else{
												$narea = '';
											}
											
											if($row['preco_promocional'] != NULL || $row['preco_promocional'] != '' ){
												$preco = '<small><del class="body-color">'.number_format($row['preco'], 0, ',', ' ').'€</del></small><br>
															<span class="heading-color fw600">'.number_format($row['preco_promocional'], 0, ',', ' ').'€</span>';
											}else{
												$preco = '<span class="heading-color fw600 lheigh">'.number_format($row['preco'], 0, ',', ' ').'€</span>';
											}
																						
											if($row['novidade'] != NULL || $row['novidade'] != '' ){
												$destaque1 = '  <ul class="tag style2 mb0">
																<li class="list-inline-item"><a href="#">NOVIDADE</a></li>
															</ul>';
											}else{
												$destaque1 = '';
											}
											
											if($row['destaque'] != NULL || $row['destaque'] != '' ){
												$destaque2 = '  <ul class="tag mb0">
																	<li class="list-inline-item"><a href="#">DESTAQUE</a></li>
																</ul>';
											}else{
												$destaque2 = '';
											}
											
											if($row['reservado'] != NULL || $row['reservado'] != '' ){
												$destaque3 = '  <ul class="tag2 mb0">
																	<li class="list-inline-item"><a href="#">RESERVADO</a></li>
																</ul>';
											}else{
												$destaque3 = '';
											}
											
											if($row['vendido'] != NULL || $row['vendido'] != '' ){
												$destaque4 = '  <ul class="tag2 mb0">
																	<li class="list-inline-item"><a href="#">VENDIDO</a></li>
																</ul>';
											}else{
												$destaque4 = '';
											}
											
											$result_fotos = $pdo->prepare("SELECT * FROM `imoveis-imagens` WHERE `id_imovel` = :id");
											$result_fotos->execute(array('id' => $row['id_imovel']));
											$num_rows_fotos = $result_fotos->rowCount();
											$row_fotos = $result_fotos->fetch();
											if ($num_rows_fotos > 0) {
												$nfotos = $num_rows_fotos;
											}else{
												$nfotos = 0;
											}
											
											$idimovel = $row['id_imovel'];
											echo '	<div class="col-lg-6 col-xl-3">
														<div class="feat_property" onclick="window.location.href=\'imovel.php?id='.$idimovel.' \'">
															<div class="thumb">
																<img class="img-whp" src="images/imoveis/'.$row['id_imovel'].'/'.$row['img_miniatura'].'" alt=" ">
																<div class="thmb_cntnt">
																	'.$destaque1.$destaque2.$destaque3.$destaque4.'
																</div>
																<div class="thmb_cntnt2">
																	<ul class="listing_gallery mb0">
																		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> '.$nfotos.'</a></li>
																	</ul>
																</div>
															</div>
															<div class="details">
																<div class="tc_content">
																	<h4><a href="imovel.php?id='.$row['id_imovel'].'">'.$row['imovel'].'</a></h4>
																	<p>'.$row['cidade'].'</p>
																	<ul class="prop_details mb0">
																		'.$nquartos.$nwc.$ngaragem.$narea.'
																	</ul>
																</div>
																<div class="fp_footer">
																	<ul class="fp_meta float-left mb0">
																		<li class="list-inline-item">
																			<a href="imovel.php?id='.$row['id_imovel'].'">
																				'.$preco.'
																			</a>
																		</li>
																	</ul>
																	<ul class="fp_meta float-right mb0">													
																		<li class="list-inline-item"><a class="icon" href="imovel.php?id='.$row['id_imovel'].'"><span class="flaticon-add"></span></a></li>
																	</ul>
																</div>
															</div>
														</div>
													</div>';
										}
									}
								?>
							</div>
						</div>
					</div>
				</div>
			</section>
			
			<!-- Our Footer -->
			<?php include 'footer.php'; ?>
			<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
		</div>
		<!-- Wrapper End -->
		<script src="js/jquery-3.6.0.js"></script>
		<script src="js/jquery-migrate-3.0.0.min.js"></script>
		<script src="js/popper.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.mmenu.all.js"></script>
		<script src="js/ace-responsive-menu.js"></script>
		<script src="js/bootstrap-select.min.js"></script>
		<script src="js/isotop.js"></script> 
		<script src="js/snackbar.min.js"></script>
		<script src="js/simplebar.js"></script>
		<script src="js/parallax.js"></script>
		<script src="js/scrollto.js"></script>
		<script src="js/jquery-scrolltofixed-min.js"></script>
		<script src="js/jquery.counterup.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/progressbar.js"></script>
		<script src="js/slider.js"></script>
		<script src="js/pricing-slider.js"></script>
		<script src="js/timepicker.js"></script>
		<!-- Custom script for all pages --> 
		<script src="js/script.js"></script>
	</body>
</html>