<?php
	include 'config.php';
	
	if (!isset($_GET['id']) || $_GET['id'] == "") { 
		header ("Location: mediacao.php");
		}else{
		$id = $_GET['id'];
	}
	
	$result_imovel = $pdo->prepare("SELECT * FROM `imoveis` WHERE `id_imovel` = :id");
	$result_imovel->execute(array('id' => $id));
	$num_rows_imovel = $result_imovel->rowCount();
	
	if($num_rows_imovel>0){
		$row_imovel = $result_imovel->fetch();
		$imovel = $row_imovel['imovel'];
		
		if($row_imovel['quartos'] != NULL || $row_imovel['quartos'] != '' ){
			$nquartos = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-bed pr5 vam"></span> '.$row_imovel['quartos'].' Quartos</a></li>';
			}else{
			$nquartos = '';
		}
		
		if($row_imovel['wc'] != NULL || $row_imovel['wc'] != '' ){
			$nwc = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-bath pr5 vam"></span> '.$row_imovel['wc'].' WCs</a></li>';
			}else{
			$nwc = '';
		}
		
		if($row_imovel['garagem'] != NULL || $row_imovel['garagem'] != '' ){
			$ngaragem = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-car pr5 vam"></span> '.$row_imovel['garagem'].' Garagem</a></li>';
			}else{
			$ngaragem = '';
		}
		
		if($row_imovel['area_bruta'] != NULL || $row_imovel['area_bruta'] != '' ){
			$narea = '<li class="list-inline-item mr20"><a class="mr20" href="#"><span class="flaticon-ruler pr5 vam"></span> '.$row_imovel['area_bruta'].' m<sup>2</sup></a></li>';
			}else{
			$narea = '';
		}
		
		if($row_imovel['ano'] != NULL || $row_imovel['ano'] != '' ){
			$ano = '<li class="list-inline-item mr20"><a href="#"><span class="flaticon-calendar pr5 vam"></span> Ano de construção: '.$row_imovel['ano'].'</a></li>';
			}else{
			$ano = '';
		}
		
		$result_estado = $pdo->prepare("SELECT * FROM `estado` WHERE `id_estado` = :id");
		$result_estado->execute(array('id' => $row_imovel['estado']));
		$row_estado = $result_estado->fetch();	
		$estado = $row_estado['estado'];
		
		$result_tipo = $pdo->prepare("SELECT * FROM `tipo` WHERE `id_tipo` = :id");
		$result_tipo->execute(array('id' => $row_imovel['tipo']));
		$row_tipo = $result_tipo->fetch();	
		$tipo = $row_tipo['tipo'];
		
		$result_tipologia = $pdo->prepare("SELECT * FROM `tipologia` WHERE `id_tipologia` = :id");
		$result_tipologia->execute(array('id' => $row_imovel['tipologia']));
		$row_tipologia = $result_tipologia->fetch();	
		$tipologia = $row_tipologia['tipologia'];
		
		
		if($row_imovel['preco_promocional'] != NULL || $row_imovel['preco_promocional'] != '' ){
			$preco = '<div class="price mt20 mb10"><h3><small class="mr10"><del>'.$row_imovel['preco'].'€</del></small> '.$row_imovel['preco_promocional'].'€</h3></div>';
			$preco2 = $row_imovel['preco_promocional'];
			}else{
			$preco = '<div class="price mt20 mb10"><h3>'.$row_imovel['preco'].'€</h3></div>';
			$preco2 = $row_imovel['preco'];
		}
		}else{
		header ("Location: mediacao.php");
	}
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="advanced search, agency, agent, classified, directory, google maps, house, listing, property, real estate, real estate agency, real estate agent, realestate, realtor, rental">
		<meta name="description" content="Houzing - Real Estate HTML Template">
		<meta name="CreativeLayers" content="ATFN">
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.css">
		<!-- Title -->
		<title><?php echo $imovel; ?> | INVINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav --> 
			<?php include 'header.php'; ?>
			
			<!-- Listing Single Property -->
			<!--<section class="listing-title-area pb0">
				<div class="container">
				<div class="row mb30">
				<div class="col-lg-7 col-xl-7">
				<div class="single_property_title mt30-767">
				<div class="breadcrumb_content style3">
				<ol class="breadcrumb mb0">
				<li class="breadcrumb-item"><a href="#">Home</a></li>
				<li class="breadcrumb-item"><a href="#">Apartamentos</a></li>
				<li class="breadcrumb-item active style2" aria-current="page">Apartamento T3 no centro de São João da madeira</li>
				</ol>
				</div>
				</div>
				</div>
				</div>
				</div>
			</section>-->
			
			<!-- Property Listing Single V4 Home Area -->
			<div class="single_page_listing_tab mt30">
				<div class="container">
					<div class="row">
						<div class="col-lg-12">
							<ul class="nav nav-tabs" id="myTab2" role="tablist">
								<li class="nav-item">
									<a class="nav-link active" id="slider-tab" data-toggle="tab" href="#slider_tabs" role="tab" aria-controls="slider_tabs" aria-selected="true"><span class="flaticon-picture color-white"></span></a>
								</li>
								<li class="nav-item">
									<a class="nav-link" id="map-tab" data-toggle="tab" href="#map_tabs" role="tab" aria-controls="map_tabs" aria-selected="false"><span class="flaticon-map color-white"></span></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="tab-content" id="myTabContent2">
								<div class="tab-pane fade show active" id="slider_tabs" role="tabpanel" aria-labelledby="slider-tab">
									<!-- 10th Home Slider -->
									<div class="home10-mainslider">
										<div class="container p0">
											<div class="row">
												<div class="col-lg-12">
													<div class="property_sp3_slider psp_v4">
														<?php
															$result_fotos = $pdo->prepare("SELECT * FROM `imoveis-imagens` WHERE `id_imovel` = :id");
															$result_fotos->execute(array('id' => $id));
															$num_rows_fotos = $result_fotos->rowCount();
															
															if ($num_rows_fotos > 0) {
																for($i=0; $i<$num_rows_fotos; $i++){
																	$row_fotos = $result_fotos->fetch();
																	
																	echo '	<div class="item">
																	<div class="sps_content">
																	<div class="thumb">
																	<div class="single_product">
																	<div class="single_item">
																	<div class="thumb"><img class="img-fluid bdrs3" src="images/imoveis/'.$id.'/'.$row_fotos['imagem'].'" alt=""></div>
																	</div>
																	<a class="product_popup popup-img" href="images/imoveis/'.$id.'/'.$row_fotos['imagem'].'"><span class="flaticon-zoom-in"></span></a>
																	</div>
																	</div>
																	</div>
																	</div>';
																}
															}
														?>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="tab-pane fade" id="map_tabs" role="tabpanel" aria-labelledby="map-tab">
									<div class="h600" id="map-canvas"></div>
								</div>
								<div class="tab-pane fade" id="street_view" role="tabpanel" aria-labelledby="street-view-tab">
									<iframe class="h600 w100" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3015.802310827744!2d-8.495041184589349!3d40.89815117931203!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xd2381e52f2ee363%3A0xe2c2feb45b9dda7b!2sR.%20Durbalino%20Laranjeira%2051%2C%203700-214%20S%C3%A3o%20Jo%C3%A3o%20da%20Madeira!5e0!3m2!1spt-PT!2spt!4v1654185154679!5m2!1spt-PT!2spt" allowfullscreen></iframe>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Agent Single Grid View -->
			<section class="our-agent-single pt0 pb70">
				<div class="container">
					<div class="row mt30 mb30">
						<div class="col-lg-8 col-xl-8">
							<div class="single_property_title mt30-767">
								<div class="media">
									<div class="media-body">
										<h2 class="mt-0"><?php echo $imovel; ?></h2>
										<div class="df db-400 mb20-400">
											<p class="mr10"><?php echo $row_imovel['rua'];?>, <?php echo $row_imovel['cidade'];?></p>                  
										</div>
										<ul class="prop_details mb0">
											<?php
												echo $nquartos.$nwc.$ngaragem.$narea.$ano;
											?>
										</ul>
									</div>
								</div>
							</div>
						</div>
						<div class="col-lg-4 col-xl-4">
							<div class="single_property_social_share_content text-right tal-md">
								<div class="spss style2">
									<!--<ul class="mb0">
										<li class="list-inline-item icon"><a href="#"><span class="flaticon-share"></span></a></li>
									</ul>-->
								</div>
								<?php echo $preco; ?>
							</div>
						</div>
					</div>
				</div>
				<div class="container">
					<div class="row">
						<div class="col-lg-8 col-xl-9">
							<!--<div class="row">-->
								<div class="col-lg-12">
									<div class="listing_single_description mt50 mb60">
										<h4 class="mb30">Descrição</h4>
										<p class="first-Description mb25"><?php echo $row_imovel['descricao'];?></p>
									</div>
								</div>
							<!--</div>-->
							<div class="col-lg-12">
								<div class="additional_details pb40 mt50 bb1">
									<div class="row">
										<div class="col-lg-12">
											<h4 class="mb15">Detalhes</h4>
										</div>
										<div class="col-md-6 col-lg-6 col-xl-4">
											<ul class="list-inline-item">
												<li><p>ID:</p></li>
												<li><p>Preço:</p></li>
												<li><p>Estado:</p></li>
												<li><p>Natureza:</p></li>																						
											</ul>
											<ul class="list-inline-item">
												<li><p><span><?php echo $row_imovel['id_imovel'];?></span></p></li>
												<li><p><span><?php echo $preco2;?>€</span></p></li>
												<li><p><span><?php echo $estado;?></span></p></li>
												<li><p><span><?php echo $tipo;?></span></p></li>												
											</ul>
										</div>
										<div class="col-md-6 col-lg-6 col-xl-4">
											<ul class="list-inline-item">
												<li><p>Tipologia:</p></li>		
												<li><p>Área Bruta:</p></li>
												<li><p>Área Útil:</p></li>
												<li><p>Ano de construção:</p></li>											
												
											</ul>
											<ul class="list-inline-item">
												<li><p><span><?php echo $tipologia;?></span></p></li>
												<li><p><span><?php echo $row_imovel['area_bruta'];?> m<sup>2</sup></span></p></li>
												<li><p><span><?php echo $row_imovel['area_util'];?> m<sup>2</sup></span></p></li>
												<li><p><span><?php echo $row_imovel['ano'];?></span></p></li>
												
											</ul>
										</div>
										<div class="col-md-6 col-lg-6 col-xl-4">
											<ul class="list-inline-item">
												<li><p>Categoria Energética:</p></li>	
												<li><p>Quartos:</p></li>
												<li><p>WCs:</p></li>
												<li><p>Garagem:</p></li>
											</ul>
											<ul class="list-inline-item">
												<li><p><span><?php echo $row_imovel['certificado_energetico'];?></span></p></li>		
												<li><p><span><?php echo $row_imovel['quartos'];?></span></p></li>
												<li><p><span><?php echo $row_imovel['wc'];?></span></p></li>
												<li><p><span><?php echo $row_imovel['garagem'];?></span></p></li>
											</ul>
										</div>
									</div>
								</div>
							</div>
							<div class="col-lg-12">
								<div class="additional_details pb40 mt50 bb1">
									<div class="row">
										<div class="col-lg-12">
											<h4 class="mb30">Características</h4>
										</div>
										<?php
											$result_caracteristicas = $pdo->prepare("SELECT * FROM `imoveis-caracteristicas` WHERE `id_imovel` = :id");
											$result_caracteristicas->execute(array('id' => $id));
											$num_rows_caracteristicas = $result_caracteristicas->rowCount();
											
											if ($num_rows_caracteristicas > 0) {
												for($i=0; $i<$num_rows_caracteristicas; $i++){
													$row_caracteristicas = $result_caracteristicas->fetch();
													
													echo '	<div class="col-sm-6 col-xl-3">
													<div class="listing_feature_iconbox mb30">
													<div class="icon float-left mr10"><span class="flaticon-point"></span></div>
													<div class="details">
													<div class="title">'.$row_caracteristicas['caracteristica'].'</div>
													</div>
													</div>
													</div>';
												}
											}
										?>
									</div>
								</div>
							</div>
							<div class="col-lg-12">
								<div class="property_sp_videos pb40 mt50">
									<ul class="nav nav-tabs" id="myTab3" role="tablist">
										<!--<li class="nav-item" role="presentation">
											<a class="nav-link active" id="property-tab" data-toggle="tab" href="#property" role="tab" aria-controls="property" aria-selected="true">Vídeo</a>
										</li>-->
										<li class="nav-item" role="presentation">
											<a class="nav-link" id="virtual-tab" data-toggle="tab" href="#virtual" role="tab" aria-controls="virtual" aria-selected="true">Vista a 360°</a>
										</li>
									</ul>
									<div class="tab-content" id="myTabContent3">
										<!--<div class="tab-pane fade show active" id="property" role="tabpanel" aria-labelledby="property-tab">
											<div class="listing_single_video">
											<div class="property_video">
											<div class="thumb"><img class="pro_img img-fluid w100" src="images/listing/lspv.jpg" alt="lspv.jpg">
											<div class="overlay_icon"><a class="video_popup_btn popup-youtube" href="https://www.youtube.com/watch?v=oqNZOOWF8qM"><span class="flaticon-play-button"></span></a></div>
											</div>
											</div>
											</div>
										</div>-->
										<div class="tab-pane fade show active" id="virtual" role="tabpanel" aria-labelledby="virtual-tab">
											<div class="listing_single_video">
												<div class="property_video">
													<div class="thumb"><img class="pro_img img-fluid w100" src="images/listing/lspv.jpg" alt="lspv.jpg">
														<div class="overlay_icon"><a class="video_popup_btn popup-youtube" href="https://www.youtube.com/watch?v=oqNZOOWF8qM"><span class="flaticon-play-button"></span></a></div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					
						<div class="col-lg-4 col-xl-3">
							<div class="listing_single_sidebar">
								<div class="sidebar_agent_search_widget mb30">
									<div class="media">
										<h3>Pedido de Informação</h3>
									</div>
									<div class="agent_search_form">
										<form action="#">
											<div class="form-group input-group mb30">
												<input type="text" class="form-control form_control" placeholder="Nome">
											</div>
											<div class="form-group input-group mb30">
												<input type="text" class="form-control form_control" placeholder="Telefone">
											</div>
											<div class="form-group input-group mb30">
												<input type="email" class="form-control form_control" placeholder="E-mail">
											</div>
											<div class="form-group input-group mb30">
												<textarea name="form_message" class="form-control" rows="5" placeholder="Mensagem"></textarea>
											</div>
											<div class="ui_kit_checkbox">
												<div class="custom-control custom-checkbox">
													<input type="checkbox" class="custom-control-input" id="customCheck1">
													<label class="custom-control-label" for="customCheck1">Aceito a Política de Privacidade, Termos e Condições e tratamento dos meus dados para a finalidade mencionada no formulário.</label>
												</div>
											</div>
											<button type="submit" class="btn btn-block btn-thm mb10">ENVIAR</button>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	
	<!-- Feature Properties -->
	<!--<section class="feature-property bgc-alice-blue">
		<div class="container">
		<div class="row justify-content-center">
		<div class="col-lg-8">
		<div class="main-title text-center">
		<h2>Também lhe pode interessar</h2>
		</div>
		</div>
		<div class="col-lg-12">
		<div class="popular_listing_slider1">
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg2.jpg" alt="lg2.jpg">
		<div class="thmb_cntnt">
		<ul class="tag mb0">
		<li class="list-inline-item"><a href="#">Destaque</a></li>
		</ul>
		<ul class="tag2 mb0">
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Loja</a></h4>
		<p>Oliveira de Azemeis</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<small><del class="body-color">80 000€</del></small><br>
		<span class="heading-color fw600">59 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg3.jpg" alt="lg3.jpg">
		<div class="thmb_cntnt">
		<ul class="tag style2 mb0">
		<li class="list-inline-item"><a href="#">Novidade</a></li>
		</ul>
		<ul class="tag2 mb0">
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Apartamento</a></h4>
		<p>São João da Madeira</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<small><del class="body-color">80 000€</del></small><br>
		<span class="heading-color fw600">59 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg4.jpg" alt="lg4.jpg">
		<div class="thmb_cntnt">
		<ul class="tag style2 mb0">
		<li class="list-inline-item"><a href="#">Novidade</a></li>
		</ul>
		<ul class="tag2 mb0">													
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Apartamento</a></h4>
		<p>São João da Madeira</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg5.jpg" alt="lg5.jpg">
		<div class="thmb_cntnt">
		<ul class="tag2 mb0">
		<li class="list-inline-item"><a href="#">VENDIDO</a></li>
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Moradia</a></h4>
		<p>Vale de Cambra</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg6.jpg" alt="lg6.jpg">
		<div class="thmb_cntnt">
		<ul class="tag2 mb0">
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Prédio</a></h4>
		<p>Oliveira de Azemeis</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg7.jpg" alt="lg7.jpg">
		<div class="thmb_cntnt">
		<ul class="tag2 mb0">
		<li class="list-inline-item"><a href="#">VENDIDO</a></li>
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Apartamento</a></h4>
		<p>São João da Madeira</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg8.jpg" alt="lg8.jpg">
		<div class="thmb_cntnt">
		<ul class="tag style2 mb0">
		<li class="list-inline-item"><a href="#">Novidade</a></li>
		</ul>
		<ul class="tag2 mb0">
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Loja</a></h4>
		<p>São João da Madeira</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg9.jpg" alt="lg9.jpg">
		<div class="thmb_cntnt">
		<ul class="tag2 mb0">
		<li class="list-inline-item"><a href="#">RESERVADO</a></li>
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Apartamento</a></h4>
		<p>Albergaria-A-Velha</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg10.jpg" alt="lg10.jpg">
		<div class="thmb_cntnt">
		<ul class="tag2 mb0">
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Moradia</a></h4>
		<p>Ovar</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		<div class="item">
		<div class="feat_property" onclick="window.location.href='imovel.php?id=1'">
		<div class="thumb">
		<img class="img-whp" src="images/property/lg11.jpg" alt="lg11.jpg">
		<div class="thmb_cntnt">
		<ul class="tag2 mb0">
		</ul>
		</div>
		<div class="thmb_cntnt2">
		<ul class="listing_gallery mb0">
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-photo-camera mr5"></span> 22</a></li>
		<li class="list-inline-item"><a class="text-white" href="#"><span class="flaticon-play-button mr5"></span> 3</a></li>
		</ul>
		</div>
		</div>
		<div class="details">
		<div class="tc_content">
		<h4><a href="page-listing-single-v8.html">Terreno</a></h4>
		<p>Estarreja</p>
		<ul class="prop_details mb0">
		<li class="list-inline-item"><a href="#"><span class="flaticon-bed"></span> <br>4</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-bath"></span> <br>5</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-car"></span> <br>1</a></li>
		<li class="list-inline-item"><a href="#"><span class="flaticon-ruler"></span> <br>250</a></li>
		</ul>
		</div>
		<div class="fp_footer">
		<ul class="fp_meta float-left mb0">
		<li class="list-inline-item">
		<a href="#">
		<span class="heading-color fw600 lheigh">23 000€</span>
		</a>
		</li>
		</ul>
		<ul class="fp_meta float-right mb0">													
		<li class="list-inline-item"><a class="icon" href="#"><span class="flaticon-add"></span></a></li>
		</ul>
		</div>
		</div>
		</div>
		</div>
		</div>
		</div>
		</div>
		</div>
		</section>
		
	-->
	<!-- Our Footer -->
	<?php include 'footer.php'; ?>
	<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
</div>
<!-- Wrapper End -->
<script src="js/jquery-3.6.0.js"></script>
<script src="js/jquery-migrate-3.0.0.min.js"></script>
<script src="js/popper.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.mmenu.all.js"></script>
<script src="js/ace-responsive-menu.js"></script>
<script src="js/bootstrap-select.min.js"></script>
<script src="js/chart.min.js"></script>
<script src="js/chart-custome.js"></script>
<script src="js/isotop.js"></script>
<script src="js/snackbar.min.js"></script>
<script src="js/simplebar.js"></script>
<script src="js/parallax.js"></script>
<script src="js/scrollto.js"></script>
<script src="js/jquery-scrolltofixed-min.js"></script>
<script src="js/jquery.counterup.js"></script>
<script src="js/wow.min.js"></script>
<script src="js/progressbar.js"></script>
<script src="js/slider.js"></script>
<script src="js/timepicker.js"></script>
<script src="js/wow.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM&callback=initMap"></script>
<script src="js/googlemaps1.js"></script>
<script src="js/googlemaps2.js"></script>
<!-- Custom script for all pages --> 
<script src="js/script.js"></script>
</body>
</html>										