<?php
	include 'config.php';
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="keywords" content="advanced search, agency, agent, classified, directory, google maps, house, listing, property, real estate, real estate agency, real estate agent, realestate, realtor, rental">
		<meta name="description" content="Houzing - Real Estate HTML Template">
		<meta name="CreativeLayers" content="ATFN">
		<!-- css file -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/style.css">
		<!-- Responsive stylesheet -->
		<link rel="stylesheet" href="css/responsive.css">
		<!-- Title -->
		<title>Investimentos | INVINCI</title>
		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
		<link rel="manifest" href="favicon/site.webmanifest">
		<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">
		
		<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<style>
			.inner_page_breadcrumb{
				background-image: url(images/Banner_5.jpg);
			}
			
			.btn{
				background-color: #1C2945;
				border-radius: 3px;
				color: #fff;
				font-size: 13px;
				height: 55px;
				line-height: 45px;
				text-transform: uppercase;
				width: 176px;
			}
			
			.btn:hover{
				background-color: #fff;
    border: 1px solid #1C2945;
    color: #1C2945;
			}
		</style>
		</head>
	<body>
		<div class="wrapper">
			<div class="preloader"></div>
			
			<!-- Main Header Nav --> 
			<?php include 'header.php'; ?>
			<!-- Modal -->
			<div class="sign_up_modal modal fade" id="logInModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
						</div>
						<div class="modal-body container pb30 pl0 pr0 pt0">
							<div class="row">
								<div class="col-lg-12">
									<ul class="sign_up_tab nav nav-tabs" id="myTab" role="tablist">
										<li class="nav-item">
											<a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Sign in</a>
										</li>
										<li class="nav-item">
											<a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Register</a>
										</li>
									</ul>
								</div>
							</div>
							<div class="tab-content container" id="myTabContent">
								<div class="row mt30 tab-pane fade show active pl20 pr20" id="home" role="tabpanel" aria-labelledby="home-tab">
									<div class="col-lg-12">
										<div class="login_form">
											<form action="#">
												<div class="mb-2 mr-sm-2">
													<label for="formGroupExampleInput" class="form-label mb0">Login</label>
													<input type="text" class="form-control" id="formGroupExampleInput" placeholder="Ali Tufa..">
												</div>
												<div class="form-group mb5">
													<input type="password" class="form-control" placeholder="Password">
												</div>
												<div class="custom-control custom-checkbox">
													<input type="checkbox" class="custom-control-input" id="exampleCheck2">
													<label class="custom-control-label" for="exampleCheck2">Remember me</label>
													<a class="btn-fpswd float-right text-thm" href="#">Forgot</a>
												</div>
												<button type="submit" class="btn btn-log btn-block btn-thm mt20">Sign in</button>
												<div class="row mt10">
													<div class="col-lg-12">
														<div class="user_log_info">
															<p>Username: <span>agency or agent</span></p>
															<p>Password: <span>demo</span></p>
														</div>
													</div>
												</div>
											</form>
										</div>
									</div>
								</div>
								<div class="row mt30 tab-pane fade pl20 pr20" id="profile" role="tabpanel" aria-labelledby="profile-tab">
									<div class="col-lg-12">
										<div class="sign_up_form">
											<form action="#">
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="Login">
												</div>
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="First name">
												</div>
												<div class="form-group input-group">
													<input type="text" class="form-control" placeholder="Last name">
												</div>
												<div class="form-group input-group">
													<select class="selectpicker form-control" data-width="100%">
														<option data-tokens="banking">User role</option>
														<option data-tokens="digital&creative">User role 2</option>
														<option data-tokens="retail">User role 3</option>
														<option data-tokens="humanresource">User role 4</option>
													</select>
												</div>
												<div class="form-group input-group">
													<input type="email" class="form-control" placeholder="Email">
												</div>
												<div class="form-group input-group mb20">
													<input type="password" class="form-control" placeholder="Password">
												</div>
												<div class="form-group input-group mb30">
													<input type="password" class="form-control" placeholder="Re-enter password">
												</div>
												<button type="submit" class="btn btn-signup btn-block btn-dark mb0">REGISTER</button>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			
			<!-- Inner Page Breadcrumb -->
			<section class="inner_page_breadcrumb">
			</section>
			
			<!-- Listing Grid View -->
			<section class="our-listing pb70 pt20">
				<div class="container d-none d-lg-block">
				<?php					
					$result_imovel = $pdo->prepare("SELECT * FROM `investimentos` ORDER BY `ordem` ASC");
					$result_imovel->execute();
					$num_rows_imovel = $result_imovel->rowCount();
					
					if($num_rows_imovel>0){
						for($i=0; $i<$num_rows_imovel; $i++){
							$row_imovel = $result_imovel->fetch();
							if($i % 2 == 0){
								echo '	<div class="row">
											<div class="col-md-6">
												<h4 class="mb10 mt50 titulo-inv1">'.$row_imovel['subtitulo'].'</h4>
												<h1 class="mb30">'.$row_imovel['titulo'].'</h1>
												<p class="mb20">'.$row_imovel['descricao'].'</p>
												<a href="'.$row_imovel['botao'].'" target="_blank" class="btn">Saber mais</a>
											</div>
											<div class="col-md-6">
												<img class="img-whp" src="images/'.$row_imovel['imagem'].'" alt="">
											</div>
										</div>'; 
							}else{
								echo '	<div class="row">
											<div class="col-md-6">
												<img class="img-whp" src="images/'.$row_imovel['imagem'].'" alt="">
											</div>
											<div class="col-md-6">
												<h4 class="mb10 mt50 titulo-inv1">'.$row_imovel['subtitulo'].'</h4>
												<h1 class="mb30">'.$row_imovel['titulo'].'</h1>
												<p class="mb20">'.$row_imovel['descricao'].'</p>
												<a href="'.$row_imovel['botao'].'" target="_blank" class="btn">Saber mais</a>
											</div>
										</div>';
							}						
						}		
					}
				?>					
				</div>
				<div class="container d-block d-lg-none">
				<?php					
					$result_imovel = $pdo->prepare("SELECT * FROM `investimentos` ORDER BY `ordem` ASC");
					$result_imovel->execute();
					$num_rows_imovel = $result_imovel->rowCount();
					
					if($num_rows_imovel>0){
						for($i=0; $i<$num_rows_imovel; $i++){
							$row_imovel = $result_imovel->fetch();
							
							echo '	<div class="row">
										<div class="col-12">
											<img class="img-whp mt30" src="images/'.$row_imovel['imagem'].'" alt="">
										</div>
										<div class="col-12">
											<h4 class="mb10 mt30 titulo-inv1">'.$row_imovel['subtitulo'].'</h4>
											<h1 class="mb30">'.$row_imovel['titulo'].'</h1>
											<p class="mb20">'.$row_imovel['descricao'].'</p>
											<a href="'.$row_imovel['botao'].'" target="_blank" class="btn mb50">Saber mais</a>
										</div>
									</div>';
						}		
					}
				?>
					
				</div>
			</section>
			
			<!-- Our Footer -->
			<?php include 'footer.php'; ?>
			<a class="scrollToHome" href="#"><i class="fa fa-angle-up"></i></a>
			
		</div>
		<!-- Wrapper End -->
		<script src="js/jquery-3.6.0.js"></script>
		<script src="js/jquery-migrate-3.0.0.min.js"></script>
		<script src="js/popper.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.mmenu.all.js"></script>
		<script src="js/ace-responsive-menu.js"></script>
		<script src="js/bootstrap-select.min.js"></script>
		<script src="js/isotop.js"></script> 
		<script src="js/snackbar.min.js"></script>
		<script src="js/simplebar.js"></script>
		<script src="js/parallax.js"></script>
		<script src="js/scrollto.js"></script>
		<script src="js/jquery-scrolltofixed-min.js"></script>
		<script src="js/jquery.counterup.js"></script>
		<script src="js/wow.min.js"></script>
		<script src="js/progressbar.js"></script>
		<script src="js/slider.js"></script>
		<script src="js/timepicker.js"></script>
		<!-- Custom script for all pages --> 
		<script src="js/script.js"></script>
	</body>
</html>